/*
 * $Id: rip.h,v 1.6 1996/12/23 14:36:33 masaki Exp $
 */

#ifndef _RIP_H
#define _RIP_H

#include <linked_list.h>
#include <trace.h>
#include <timer.h>
#include <schedule.h>
#include <hash.h>
#include <mrt.h>


#define RIP_DEFAULT_PORT	520
#define RIP_MAX_PDU		512

#define RIP_REQUEST	1
#define RIP_RESPONSE	2

#define RIP_VERSION	1

#define RIP_TIMEOUT_INTERVAL	180
#define RIP_GARBAGE_INTERVAL	240
#define RIP_UPDATE_INTERVAL	30
#define RIP_HOPCNT_INFINITY	16

/* #define PROTO_RIP		0x04 */

typedef struct _rip_t {
   u_short	compat_switch;  /* rip1-2 compatibility */
   u_long	interface_mask;	/* mask of interfaces rip is configed for */
   int		sockfd;		/* socket we are listeing on -- -1 if not listening */
   HASH_TABLE	*hash;		/* hash of prefixes */
   trace_t	*trace;

   int (*change_call_fn)();
   int (*add_call_fn)();
   schedule_t	*schedule;
   mtimer_t	*timer;		/* one timer used for update, garbage, etc */
} rip_t;

#define COMPAT_RIP_NOE		0	/* no rip messages sent */
#define COMPAT_RIP1_ONLY	1	/* only rip1 messages sent */
#define COMPAT_RIP1_COMPAT	2	/* rip2 messages broadcast */
#define COMPAT_RIP2_ONLY	3	/* rip2 multicast */



typedef struct _rip_attr_t {
   u_char	type;	
   prefix_t*	nexthop;
  /*long		next_hop;*/
   int 		ref_count;
   gateway_t	*gateway;
   short	local;

   u_char	version;
   u_char	metric;
   u_short	tag;
   u_long	mask;
} rip_attr_t;


typedef struct _rip_route_t {
  u_long	flags;
  prefix_t	*prefix;
  rip_attr_t	*attr;
  long		time;
} rip_route_t;


/* route flags */
#define RT_RIP_CHANGE	1

extern rip_t *RIP;

/* user settable attributes */
enum RIP_ATTR {
   RIP_NULL = 0,
   RIP_TRACE_STRUCT,
   RIP_RT_CHANGE_FN,
   RIP_RT_ADD_FN,
   RIP_USE_PORTSERVER		/* use portserver library for listening */
};


/* public functions */
rip_route_t*	New_Rip_Route (prefix_t *prefix, rip_attr_t *attr);
int		Delete_Rip_Route (rip_route_t *route);
rip_attr_t *New_Rip_Attr (int metric);

#endif /* _RIP_H */
