typedef struct _PortServ_Port {
   int sockfd;
   int port;
   LINKED_LIST *ll_clients;	/* list of process who have interest in port */
} PortServ_Port;


typedef struct _PortServ_Client {
   char *name;
   int sockfd;		/* open socket to process */
   int port;		/* port process has registered */
   long address;	/* IP address process has registered */
   long client_address;	/* IP address of client process */
   PortServ_Port *p_port;
} PortServ_Client;


typedef struct _Master_Struct {
   int sockfd;
   LINKED_LIST *ll_ports;
   LINKED_LIST *ll_clients;
   fd_set fdvar_read, fdvar_write, fdvar_except;

   /* when get SIGPIPE, know which client we were writing to */
   PortServ_Client *last_client;
   int last_fd;

} Master_Struct;



void kill_port_server ();
void init ();
PortServ_Client *New_Client (int sockfd, int port, long addr, PortServ_Port *p_port);
PortServ_Port *New_Port (long port);
int process_portserv_port ();
int process_client_ports ();
int register_client (int fd);
PortServ_Client *find_client (LINKED_LIST *ll_clients, long addr, long port);
void port_serv_broken_pipe ();
void mainloop ();
void destroy_port (PortServ_Port *p_port);
void tell_client (int fd, int status, int error_code);

/* internal routines */
int _ps_port_find (PortServ_Port *ps_port, int *port);

