#!/bin/perl

#
# $Id: agg.pl,v 1.1.1.1 1996/04/09 15:50:40 labovit Exp $
#

# aggstats - get aggregation stats from router dump  
# expects the results of `show ip bgp` on standard input
# i use cisco_fetch, from the ra folk, to get it in an automated fashion
# Randy Bush <randy@psg.com>
# 95.07.30  hacked up
# 95.08.25  a few comments because folk asked to steal it

sub numeric { $a <=> $b }

while (<>) {
  # get the target network
  if (($ad) = /^\*. (\S+)/) {
    # if it is a declared aggregate is has a /#, increment both counts
    if ($ad =~ /\/(.+)/) { ++$aggs{$1}; ++$totl{$1} }
    # then we have to assume the prefic length from old-style class
    else { $ad =~ /(.+)\./;
      if ( 128 > $1 )    { ++$totl{8}  }
      elsif ( 192 > $1 ) { ++$totl{16} }
      else               { ++$totl{24} }
      }
    }
  }
printf "\npfx    aggrs    total\n---    -----    -----\n";
foreach $prefix (sort numeric keys(%totl)) {
  printf "/%2d %8d %8d\n", $prefix, $aggs{$prefix}, $totl{$prefix};
  $agg+=$aggs{$prefix};
  $tot+=$totl{$prefix}
  }
printf "Total networks:    %8d\n", $tot;
printf "Total with netmask:%8d\n", $agg

