#include <stdio.h>
#include <patricia.h>

void stack_init(pstack_t *S)
{  
  *S = NULL; 
}

NODE_TYPE stack_pop(pstack_t *S)
{
  pstack_t TempPtr;
  NODE_TYPE node;

  TempPtr = *S;
  node = (*S)->node;
  (*S) = (*S)->prev;
  if (*S == NULL)
    free(TempPtr);
  else
    {
    (*S)->next = NULL;
    TempPtr->prev = NULL;
    free(TempPtr);
  }
  return node;
}
 
void stack_push(NODE_TYPE node, pstack_t *S)
{
  pstack_t TempPtr;

  TempPtr = (pstack_t ) malloc(sizeof(struct s_entry));
  TempPtr->node = node;
  TempPtr->next = NULL;
  if (*S != NULL) 
    {
     TempPtr->prev = *S;
     (*S)->next = TempPtr;
     (*S) = (*S)->next;
   }
  else
    {
     TempPtr->prev = NULL;
     *S = TempPtr;
   }
}

stack_empty(pstack_t S)
{
  return (S == NULL);
}







