/*
 * $Id: user.h,v 1.7 1997/03/21 10:31:49 masaki Exp $
 */

#ifndef _USER_H
#define _USER_H

#include <New.h>
#include <linked_list.h>

#define UII_DEFAULT_PORT 5674
#define UII_MAX_STATE	10

#define UII_EXIT	1000	/* user connection has terminated */


/* options to set in uii */
enum UII_ATTR {
    UII_NULL = 0,
    UII_PROMPT			/* the default prompt */
};


typedef struct _uii_t {
    trace_t *trace;
    int sockfd;			/* port to listen on */
    LINKED_LIST *ll_uii_commands;
    LINKED_LIST *ll_uii_connections;
    char *prompts[UII_MAX_STATE];
    int initial_state;
    char *service_name;		/* what we are called in /etc/services */
} uii_t;

typedef struct _uii_connection_t {
    int state;
    int protocol;		/* only used in configs */
    int sockfd;
    char buffer[MAXLINE];
#define MAXHIST 20
    char cmds[MAXHIST][MAXLINE];
    int cmdcp;			/* number of current cmd */
    int cmdend;			/* end of cmd history */
    char tmp[MAXLINE];
    char *cp;			/* pointer to cursor in line */
    char *end;			/* pointer to end of line */
    int negative;		/* no .... = 1 */

    schedule_t *schedule;
} uii_connection_t;

/* Each object submits a list of commands that is will respond to */
typedef struct _uii_command_t {
    char string[100];
    int (*call_fn) ();
    int state;			/* 0 unpriv, 1 normal, 2 config, 3 config router */
} uii_command_t;

#define UII_UNPREV 	        0
#define UII_NORMAL              1
#define UII_CONFIG              2
#define UII_CONFIG_ROUTER       3
#define UII_CONFIG_INTERFACE    4

extern uii_t *UII;

int uii_add_command (int state, char *cmd, int (*call_fn) ());
uii_t *New_UII (trace_t * ltrace);
int uii_send_data (uii_connection_t * uii,...);
int init_uii (trace_t * trace);
int listen_uii ();
int listen_uii2 (char *port);
char *uii_parse_line (char **line);
int parse_line (char *line, char *format, ...);

#endif /* _USER_H */
