/*
 * $Id: io.h,v 1.5 1997/03/21 10:31:38 masaki Exp $
 */

#ifndef _IO_H
#define _IO_H

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <mrt.h>
#include <timer.h>
#include <schedule.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */

/* All programs use BASE_KEY as the base for their message-queue key.
   BASE_KEY has been chosen arbitrarily and will hopefully not
   conflict with other applications running on the same machine.  The
   message server uses the special value BASE_KEY | 1 for its message
   queue.  All others use GETKEY(), which bases the key on PID.  (This
   could be augmented with thread-ID, if it becomes necessary.)  */
#define BASE_KEY	(0x50 << 16)
#define MSGSERVER_KEY	(BASE_KEY | 1)
#define GETKEY()	(BASE_KEY | getpid())

/* maximum length of a client ID */
#define CLIENTLEN 80

/* this is misleading, since it has nothing to do with the message-queue
   I/O functions. */
#define MAX_MSG_SIZE             8192

union IO_Handle {
   int fd;
   struct {
      int mqid;
      char clientid[CLIENTLEN];
   } mq;
};

typedef struct _io_t {
   pthread_mutex_t   	mutex_lock;
   schedule_t		*schedule;	/* event processing */
   trace_t		*trace;
   long			last;
   int io_input_type;
   int io_output_type;
   char *io_out_name;
   void (*call_fn)();
   union IO_Handle in;
   union IO_Handle out;
} io_t;

io_t *MASTER_IO;
extern char *S_MRT_MSG_TYPES[];
extern char *S_MRT_MGS_BGP_TYPES[];

typedef struct _MQINFO_Struct {
   char client[CLIENTLEN];
   key_t key;
} MQINFO_Struct;

/* I/O types -- used for io_input_type and io_output_type */
enum IO_TYPES {
   IO_NONE,
   IO_FILE,
   IO_MSGQ
};

/* I/O attributes -- used as key in set_io arglist */
enum IO_ATTR {
   IO_NULL = 0,
   IO_INNONE,			/* no input */
   IO_OUTNONE,			/* no output */
   IO_OUTFILE,			/* output to file (truncate) */
   IO_OUTAPPEND,		/* output to file (append) */
   IO_INFILE,			/* input from file */
   IO_INMSGQ,			/* input from message queue */
   IO_OUTMSGQ,			/* output to message queue */
   IO_RECV_CALL_FN		/* async func to call on new input */
};

/* message types for an ARB_MSG_Struct */
enum ARB_MSG_TYPES {
   MSG_SETMBOX,			/* set a client/mailbox association */
   MSG_GETMBOX,			/* get a client/mailbox association */
   MSG_CLRMBOX,			/* remove a client/mailbox association */
   MSG_DUMP,			/* dump hash table on stderr */
   MSG_SHUTDOWN			/* shut down */
};

enum MRT_MSG_TYPES {
   MSG_NULL,
   MSG_START,			/* sender is starting up */
   MSG_DIE,			/* receiver should shut down */
   MSG_I_AM_DEAD,		/* sender is shutting down */
   MSG_PEER_DOWN,		/* sender's peer is down */
   MSG_PROTOCOL_BGP,		/* msg is a BGP packet */
   MSG_PROTOCOL_RIP,		/* msg is a RIP packet */
   MSG_PROTOCOL_IDRP		/* msg is an IDRP packet */
};

enum MRT_MGS_BGP_TYPES {
   MSG_BGP_NULL,
   MSG_BGP_UPDATE,	/* raw update packet (contains both with and ann) */
   MSG_BGP_PREF_UPDATE  /* tlv preferences followed by raw update */
};

typedef struct _ARB_MSG_Struct {
   long priority;		/* required by msgget/msgrcv */
   enum ARB_MSG_TYPES type;	/* message type */
   key_t sender;		/* sender key (for replies) */
   MQINFO_Struct mqinfo;	/* message queue info */
} ARB_MSG_Struct;

typedef struct _mrt_msg_t {
   long priority;		/* required by msgget/msgrcv */
   long tstamp;			/* timestamp */
   short type;			/* msg type, one of MRT_MSG_TYPES */
   short subtype;		/* msg subtype, protocol-specific */
   int length;			/* length of data */
   char value[MAX_MSG_SIZE];	/* data */
} mrt_msg_t;


/* Public functions */
io_t *New_IO (trace_t *tr);
int io_set(io_t *io, int first, ...);
mrt_msg_t *io_read(io_t *io);
int io_write (io_t *io, long tstamp, short type, short subtype, int length, char *value);

#endif /* _IO_H */
