/* 
 * $Id: config.c,v 1.2 1997/03/20 14:25:21 labovit Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <mrt.h>
#include <trace.h>
#include <io.h>
#include <select.h>
#include <stdarg.h>
#include <interface.h>
#include "config.h"
#include "uping.h"

/* globals */
config_master_t *CONFIG;


/* start_config
 * call by uii thread. 
 */
void start_config (uii_connection_t *uii) {
  
  uii->state = UII_CONFIG;
}


/* config_from_file
b */
int config_from_file (char *filename) {
  FILE *fd;
  uii_connection_t *uii = New (uii_connection_t);

#define UPING_CONFIG_DEFAULT_1 "/etc/uping.config"
#define UPING_CONFIG_DEFAULT_2 "./uping.config"
/* the third one is for backward compatibility */
#define UPING_CONFIG_DEFAULT_3 "./config"
  if (filename == NULL) {
    filename = UPING_CONFIG_DEFAULT_1;
    if ((fd = fopen (filename, "r")) == NULL) {
      filename = UPING_CONFIG_DEFAULT_2;
      if ((fd = fopen (filename, "r")) == NULL) {
        filename = UPING_CONFIG_DEFAULT_3;
        if ((fd = fopen (filename, "r")) == NULL) {
          trace (FATAL, CONFIG->trace, 
            "UPING failed to open all default config files %s, %s, and %s\n",
             UPING_CONFIG_DEFAULT_1, UPING_CONFIG_DEFAULT_2, UPING_CONFIG_DEFAULT_3);
          return (-1);
        }
      }
    }
  }
  else {
    if ((fd = fopen (filename, "r")) == NULL) {
      trace (FATAL, CONFIG->trace, 
         "UPING failed to open the config file %s\n", filename);
      return (-1);
    }
  }
  trace (NORM, CONFIG->trace, 
     "UPING opened the config file %s\n", filename);

  MRT->config_file_name = strdup (filename);
  start_config (uii);
  CONFIG->line = 0;

  while (fgets (uii->buffer, sizeof (uii->buffer)-1, fd) > 0) {
    CONFIG->line++;
    /* process_config (0, line);*/
    uii_proccess_command (uii);
  }
  
  fclose (fd);
  Delete (uii);
  return (0);
}



int show_config (uii_connection_t *uii) {
  char tmp[MAXLINE];
  FILE *fd;
  
  if ((fd = fopen (MRT->config_file_name, "r")) == NULL) {return (-1);}

  while (fgets (tmp, sizeof (tmp) - 1, fd)) {
    uii_send_data (uii, "%s\r", tmp);
  }
  fclose (fd);
}



int config_comment (uii_connection_t *uii) {
  if (strlen (uii->cp) < 2) {
    trace (TR_PARSE, CONFIG->trace, "COMMENT -- STATE EOF %s", uii->cp);
    uii->state = UII_CONFIG;
  }
  
  trace (TR_PARSE, CONFIG->trace, "COMMENT %s", uii->cp);
  return (1);
}


/* strip off the begining and trailing space characters */
char *strip_spaces (char *tmp) {
    char *cp = tmp, *pp;
    while (*cp && isspace (*cp)) cp++;
    if (*cp) {
      pp = cp+strlen(cp)-1;
      while (pp > cp && isspace (*pp)) pp--;
      pp[1] = '\0';
    }
    return (cp);
}


int password (uii_connection_t *uii) {
  char tmp[MAXLINE], *cp;

  tmp[0] = '\0';
  if (parse_line (uii->cp, "%s", tmp) >= 1) {
    cp = strip_spaces (tmp);
  }
  if (*cp) {
    UII->initial_state = 0; /* password required */
    CONFIG->password = strdup (cp);
  }
}


void check_passwd (uii_connection_t *uii) {
  char tmp[MAXLINE], *cp = tmp;

  tmp[0] = '\0';
  if (parse_line (uii->cp, "%S", tmp) >= 1) {
    cp = strip_spaces (tmp);
  }
  if (CONFIG->password == NULL || strcmp (CONFIG->password, cp) == 0)
    uii->state = 1;
  else {
    trace (INFO|NORM, MRT->trace, "INVALID PASSWORD: [%s]\n", cp);
  }
}

int parse_debug (uii_connection_t *uii, trace_t *trace) {
  char *token, *line;
  u_long flag = 0;
  line = uii->cp;

  /* get flag */
  if ((token = (char *) uii_parse_line (&line)) == NULL) return (-1);
  flag = trace_flag (token);
  set_trace (trace, TRACE_FLAGS, flag, NULL);

  /* get file name (OPTIONAL) */
  if ((token = (char *) uii_parse_line (&line)) == NULL) return (1);
  set_trace (trace, TRACE_LOGFILE, token, NULL);

  return (1);
}

void config_debug (uii_connection_t *uii) {
  parse_debug (uii, CONFIG->trace);
}


void config_password (uii_connection_t *uii) {
  parse_line (uii->cp, "%s", CONFIG->password);
  trace (INFO|NORM, MRT->trace, "CONFIG Password\n");
}



/* config salamander host
 */
void config_publish (uii_connection_t *uii) {
  prefix_t *dst;
  u_long key;

  if (parse_line (uii->cp, "%p %d", &CONFIG->publish_prefix, &CONFIG->key) >= 2) {
    trace (NORM, CONFIG->trace, "CONFIG salamander host %s with key %d\n", 
	   prefix_toa (CONFIG->publish_prefix), CONFIG->key);
  }
}


void config_uping_host (uii_connection_t *uii) {
  prefix_t *dst, *next_hop;
  u_char ether[6];
  struct ether_addr e;
  uping_dst_t *uping_dst;
  u_long as;

  if (parse_line (uii->cp, "%d %p via %p", &as, &dst, &next_hop) >= 2) {
    arp (prefix_tochar(next_hop), ether);
    uping_dst = New (uping_dst_t);
    pthread_mutex_init (&uping_dst->mutex_lock, NULL);
    uping_dst->dst = dst;
    uping_dst->type = 1;
    uping_dst->AS = (u_short) as;
    uping_dst->ll_sent = LL_Create (NULL);
    memcpy (&uping_dst->ether_addr, &ether, 6);
    trace (NORM, CONFIG->trace, "CONFIG ping AS%d %s via %s\n", 
	   uping_dst->AS,
	   prefix_toa (uping_dst->dst), ether_ntoa (ether));
    LL_Add (ll_uping_dst, uping_dst);
    uping_add_peer (uping_dst->dst); /* open feeback TCP connection to peer */
  }
  

  
}

void config_uping_local (uii_connection_t *uii) {
  prefix_t *dst;
  u_char ether[6];
  struct ether_addr e;
  uping_dst_t *uping_dst;
  u_long as;

  if (parse_line (uii->cp, "%d %p", &as, &dst) >= 2) {
    arp (prefix_tochar(dst), ether);
    uping_dst = New (uping_dst_t);
    uping_dst->dst = CONFIG->source_ip;
    uping_dst->AS = (u_short) as;
    uping_dst->duplicate = 0;
    uping_dst->ll_sent = LL_Create (NULL);
    memcpy (&uping_dst->ether_addr, &ether, 6);
    trace (NORM, CONFIG->trace, "CONFIG ping local AS%d %s\n", 
	   uping_dst->AS, ether_ntoa (ether));
    LL_Add (ll_uping_dst, uping_dst);
  }
}

void config_source_ip (uii_connection_t *uii) {
  char tmp[100];
  if (parse_line (uii->cp, "%p %s", &CONFIG->source_ip, tmp) >= 1) {
    /*CONFIG->device[strlen(CONFIG->device) -1] = '\0';*/
    sprintf (CONFIG->device, "/dev/%s", tmp);
    trace (NORM, CONFIG->trace, "CONFIG source_ip %s %s\n", 
	   prefix_toa (CONFIG->source_ip), CONFIG->device);
  }
}


void config_packet_size (uii_connection_t *uii) {
  char tmp[100];
  if (parse_line (uii->cp, "%d", &CONFIG->packet_size) >= 1) {
    trace (NORM, CONFIG->trace, "CONFIG packet_size %d bytes\n",
	   CONFIG->packet_size);
  }
}

void config_log_dir (uii_connection_t *uii) {
  if (parse_line (uii->cp, "%q", CONFIG->log_dir) >= 1) {
    trace (NORM, CONFIG->trace, "CONFIG log_dir %s\n",
	   CONFIG->log_dir);
  }
}

void config_interval (uii_connection_t *uii) {
  if (parse_line (uii->cp, "%d jitter %d", 
		  &CONFIG->interval, &CONFIG->jitter) >= 2) {
    trace (NORM, CONFIG->trace, 
	   "CONFIG interval between pings of %d with jitter %d\n",
	   CONFIG->interval, CONFIG->jitter);
  }
}

void config_name (uii_connection_t *uii) {
  if (parse_line (uii->cp, "%s", CONFIG->name) >= 1) {
    trace (NORM, CONFIG->trace, "CONFIG name %s\n", CONFIG->name);
  }
}


int init_config (trace_t *trace) {


  CONFIG = New (config_master_t);
  CONFIG->trace = trace_copy (trace);
  CONFIG->ll_static_dest = NULL;
  CONFIG->ll_static_attr = NULL;
  CONFIG->interface = NULL;
  CONFIG->tunnel_source = NULL;
  CONFIG->password = NULL;
  CONFIG->interval = 10;
  CONFIG->jitter = 5;
  CONFIG->sequence = 1;
  strcpy (CONFIG->name, "uping");

  UII->initial_state = 1; /* no password required */
  uii_add_command (UII_NORMAL, "show config", (void *) show_config);

  /* config top level */
  uii_add_command (UII_CONFIG, "password", (void *) password);

  uii_add_command (UII_CONFIG, "uping", (void *) config_uping_host);
  uii_add_command (UII_CONFIG, "uping_local", (void *) config_uping_local);
  uii_add_command (UII_CONFIG, "source_ip", (void *) config_source_ip);
  uii_add_command (UII_CONFIG, "packet_size", (void *) config_packet_size);
  uii_add_command (UII_CONFIG, "log_dir", (void *) config_log_dir);
  uii_add_command (UII_CONFIG, "interval", (void *) config_interval);
  uii_add_command (UII_CONFIG, "name", (void *) config_name);
  uii_add_command (UII_CONFIG, "sequence_size", (void *) config_name);
  uii_add_command (UII_CONFIG, "publish", (void *) config_publish);

  return (1);
}
