#include <stdio.h>
#include <patricia.h>

patricia_t patricia_new(KEY_TYPE key, unsigned len, BIT_SELECT bit)
{
  patricia_t T;

  T = (patricia_t) malloc(sizeof(struct pt));
  T->key = key;
  T->pref_len = len;
  T->bit = bit;
  T->l = T;
  T->r = T;

  return T;
}  


void patricia_insert(KEY_TYPE key, unsigned len, patricia_t *root);

void patricia_walk(patricia_t pt, int function, patricia_t *np)
{
  if (higher(pt->bit, pt->l->bit)) 
    patricia_walk(pt->l, function, np);
  if (higher(pt->bit, pt->r->bit)) 
    patricia_walk(pt->r, function, np);

  if (function == DISPLAY) ip_output(pt->key, pt->pref_len); 
  if (function == INSTALL) patricia_insert(pt->key, pt->pref_len, np);

  if (function == DELETE) {
     pt->l = NULL; pt->r = NULL; 
     free(pt);
   }     

}

void patricia_walk2(patricia_t pt, int function, patricia_t *np)
{
  int mode;
  patricia_t last, trav;
  pstack_t S;
  FILE *fout;

  stack_init(&S);
  trav = pt;
  if (function == DUMP) fout = fopen("dump.patr", "w");
  
  mode = 0;   /* down searching mode */
  while (1) {
     last = trav;
     if (mode == 1) {
        if (function == DISPLAY) ip_output(trav->key, trav->pref_len);
        if (function == DUMP) { 
                                fwrite((char *)&trav->pref_len, sizeof(unsigned), 1, fout);
                                fwrite((char *)&trav->key, sizeof(long), 1, fout);
                              }
        if (function == INSTALL) patricia_insert(trav->key, trav->pref_len, np);
        if (function == DELETE ) {
           trav->l = NULL; trav->r = NULL;
           free(trav);
        } 
        if (stack_empty(S)) {
                    if (function == DUMP) close(fout);
                    return;
		  }
        trav = (patricia_t) stack_pop(&S);
        if ((trav->l == last) && higher(trav->bit, trav->r->bit)) {
                 stack_push(trav, &S);
                 trav = trav->r;
                 mode = 0;
        }
      }
     if (mode == 0) {
        if (higher(trav->bit, trav->l->bit)) {
           stack_push(trav, &S);
           trav = trav->l;
	 }
        else if (higher(trav->bit, trav->r->bit)) {
               stack_push(trav, &S);
               trav = trav->r;
             }
             else mode = 1;             
      }

  }
}


void patricia_reload(patricia_t *root)
{
   FILE *fd;
   KEY_TYPE k;
   unsigned len;
int count;
  
count = 0;
   fd = fopen("dump.patr", "r");
   do {
      fread((char *)&len, sizeof(unsigned), 1, fd);
      fread((char *)&k, sizeof(long), 1, fd);
      patricia_insert(k, len, root);
   } while (!(len == 0 && k == 0));
   close(fd);
}


patricia_t patricia_find(KEY_TYPE key, patricia_t root)
{
  patricia_t parent, trav;

  trav = root;

  do {
      parent = trav;

      if (test_bit(trav->bit, key))
         trav = trav->r;
      else  
         trav = trav->l;
  } while (higher(parent->bit, trav->bit));

  if (key != trav->key) return NULL;
  return trav;
}

patricia_t patricia_find2(KEY_TYPE key, unsigned len, patricia_t root)
{
  patricia_t parent, trav; 
  pstack_t S;

  stack_init(&S);

  trav = root;
  
  do {
       parent = trav;
       
       stack_push(parent, &S);
 
       if (test_bit(trav->bit, key))
         trav = trav->r;
       else  
         trav = trav->l;
  } while (higher(parent->bit, trav->bit));

  stack_push(trav, &S);    /* so it is tested first */

  /* search up for the best match */
  while (!stack_empty(S)) {
     trav = (patricia_t) stack_pop(&S);

     if (mask_key(key, cont_mask(trav->pref_len)) 
                     == trav->key)
       return (trav);
  }
}


void patricia_insert(KEY_TYPE key, unsigned len, patricia_t *root)
{
  patricia_t parent, trav, new_pt;
  BIT_SELECT try_bit;

  try_bit = MAX_BIT;
  trav = *root;

  do { 
       parent = trav;

       if (test_bit(trav->bit, key))
	 trav = trav->r; 
       else
	 trav = trav->l;
  } while (higher(parent->bit, trav->bit));

  if (eq_key(trav->key, key)) return; 

  while (test_bit(try_bit, key) == test_bit(try_bit, trav->key)) 
     try_bit = next_bit(try_bit); 

  trav = *root;
  do {
       parent = trav;
       
       if (test_bit(trav->bit, key))
          trav = trav->r;
       else
          trav = trav->l;
  } while (higher(trav->bit, try_bit) && higher(parent->bit, trav->bit));

  /* insert */
  new_pt = (patricia_t) patricia_new(key, len, try_bit);
 
  if (test_bit(try_bit, key)) {
      new_pt->l = trav;
      new_pt->r = new_pt;
  }
  else {
      new_pt->l = new_pt;
      new_pt->r = trav;
  }

  if (test_bit(parent->bit, key)) 
      parent->r = new_pt;
  else 
      parent->l = new_pt;

}

patricia_t find_up(patricia_t tr, BIT_SELECT bit);

patricia_t patricia_insert2(KEY_TYPE key, unsigned len, patricia_t *root)
{
  patricia_t parent, trav, next, n, pp;
  BIT_SELECT try_bit;

  trav = *root;
  do {
      parent = trav;
       
      if (test_bit(trav->bit, key))
          trav = trav->r;
       else
          trav = trav->l;
  } while (higher(parent->bit, trav->bit));


  if (eq_key(trav->key, key)) {
    if (len >= trav->pref_len) 
      return (trav);

    next = *root;
    do {
        parent = next;

        if (test_bit(next->bit, key))
           next = next->r;
        else
           next = next->l;
    } while (next != trav && 
              !eq_key(mask_key(next->key, cont_mask(len)), key));

    if (next = trav) {
        trav->pref_len = len;
        return (trav);
    }
  } 
  else {
    /* locate insertion */
     try_bit = MAX_BIT;

     while (test_bit(try_bit, key) == test_bit(try_bit, trav->key))
       try_bit = next_bit(try_bit);

     trav = *root;
     do {
          parent = trav;
     
          if (test_bit(trav->bit, key))
            trav = trav->r;
          else
            trav = trav->l;      
     } while (higher(trav->bit, try_bit) &&
              higher(parent->bit, trav->bit) &&
              !eq_key(mask_key(trav->key, cont_mask(len)), key));
  }
  

  /* test to see if it is unusual middle insertion */
  if (eq_key(mask_key(trav->key, cont_mask(len)), key)) {
    /* find where the pointer from parent would have pointed */

    if (test_bit(key, parent->bit)) {
         if (test_bit(parent->bit, parent->key))
            pp = parent;
         else
            pp = (patricia_t) find_up(parent->r, parent->bit);
    } else {
         if (!test_bit(parent->bit, parent->key)) 
             pp = parent;
         else
            pp = (patricia_t) find_up(parent->l, parent->bit);
    }

    /* determine which bit we differ from pp on */

    try_bit = MAX_BIT;
    while (test_bit(try_bit, key) == test_bit(try_bit, pp->key))
       try_bit = next_bit(try_bit);

    n = (patricia_t) patricia_new(key, len, try_bit);
    if (test_bit(try_bit, key)) {
      n->l = pp;
      n->r = n;
    } else {
       n->l = n;
       n->r = pp;
    }

    if (!test_bit(parent->bit, key) && higher(parent->bit, parent->l->bit))
       patricia_walk2(trav, INSTALL, &n);
    else 
       patricia_walk2(trav, INSTALL, &n);

    /* Hoop-up the rebuild tree */
    if (test_bit(parent->bit, key))
       parent->r = n;
    else
       parent->l = n;
 
    patricia_walk2(trav, DELETE, NULL);
    return (n);
  }
  else {  /* normal case */ 
        
        n = (patricia_t) patricia_new(key, len, try_bit); 
        if (test_bit(try_bit, key)) {
           n->l = trav;
           n->r = n;
        } else {
           n->l = n;
           n->r = trav;
        }
        
        if (test_bit(parent->bit, key))
           parent->r = n;
        else 
           parent->l = n;
	return (n);
  }
}

patricia_t patricia_parent(patricia_t pt, patricia_t root)
{
  patricia_t parent, trav, temp;
  pstack_t S;

  stack_init(&S);
  trav = root;

  do {
      parent = trav;
      stack_push(parent, &S);
      if (test_bit(trav->bit, pt->key))
         trav = trav->r;
      else  
         trav = trav->l;
  } while (higher(parent->bit, trav->bit));

  do 
     if (!stack_empty(S)) temp = (patricia_t ) stack_pop(&S);
  while (temp != trav);
  
  if (!stack_empty(S)) 
     temp = (patricia_t )stack_pop(&S); 
  else {temp = NULL; printf("No Parent..\n"); }
  
  return (temp);
}

patricia_t find_up(patricia_t tr, BIT_SELECT bit) 
{ 
  patricia_t p;
 
  if (tr->bit > bit) return tr;

  if (tr->l->bit > bit) return tr->l;
  if (tr->r->bit > bit) return tr->r;

  if (tr->bit > tr->l->bit) {
      p = find_up(tr->l, bit);
      if (p != NULL) return p;
   }
  if (tr->bit > tr->r->bit) {
      p = find_up(tr->r, bit);
      if (p != NULL) return p;
   }
  return NULL;
}

 
void patricia_delete(KEY_TYPE key, patricia_t *root)
{
  patricia_t pt, parent, pp;

  pt = (patricia_t ) patricia_find(key, *root);
  parent = (patricia_t ) patricia_parent(pt, *root);

    if (test_bit(parent->bit, key)) {
       if (test_bit(parent->bit, parent->key))
         pp = parent;
       else 
         pp = find_up(parent->r, parent->bit);

       parent->r = pp;
    } else {
        if (!test_bit(parent->bit, parent->key))
         pp = parent;
       else 
         pp = find_up(parent->l, parent->bit);
       parent->l = pp;
    }

  if (higher(pt->bit, pt->l->bit)) 
      patricia_walk2(pt->l, INSTALL, root);
  if (higher(pt->bit, pt->r->bit))
      patricia_walk2(pt->r, INSTALL, root);

  patricia_walk2(pt, DELETE, NULL);
}




