/*
 * $Id: bgp_timer.c,v 1.2 1996/06/20 20:19:26 labovit Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <mrt.h>
#include <bgp_proto.h>
#include <trace.h>
#include <timer.h> 
#include <bgp.h> 

void bgp_timer_ConnectRetry_fire (mtimer_t *timer, bgp_peer_t *peer)
{
   trace (FATAL, peer->trace, "BGP Connect Retry timer fired\n");
   bgp_sm_process_event (peer, peer->state, BGPEVENT_CONNRETRY);
}

void bgp_timer_KeepAlive_fire (mtimer_t *timer, bgp_peer_t *peer)
{
   trace (TR_TIMER, peer->trace, "BGP KeepAlive timer fired\n");
   bgp_sm_process_event (peer, peer->state, BGPEVENT_KEEPALIVE);

}


void bgp_timer_HoldTime_fire (mtimer_t *timer, bgp_peer_t *peer)
{
   trace (TR_TIMER, peer->trace, "BGP HoldTime timer fired\n");
   bgp_sm_process_event (peer, peer->state, BGPEVENT_HOLDTIME);
}


void bgp_timer_StartTime_fire (mtimer_t *timer, bgp_peer_t *peer)
{
   Timer_Turn_OFF (peer->timer_Start);
   trace (TR_TIMER, peer->trace, "BGP Start timer fired\n");
   bgp_sm_process_event (peer, peer->state, BGPEVENT_START);
}

