/* 
 * $Id: bgp_thread.c,v 1.3 1996/06/20 20:19:25 labovit Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <stdarg.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <mrt.h>
#include <timer.h>
#include <trace.h>
#include <bgp_proto.h>
#include <bgp.h>
#include <select.h>

void bgp_start_peer_thread (bgp_peer_t *peer) {
   sigset_t set;
   char tmp[MAXLINE];

   sigemptyset (&set);
   sigaddset (&set, SIGALRM);
   sigaddset (&set, SIGHUP);
   pthread_sigmask (SIG_BLOCK, &set, NULL);

   peer->schedule->self = peer->self = pthread_self ();

#ifdef HAVE_LIBPTHREAD
   trace (TR_THREAD, peer->trace, "THREAD starting for %s\n", 
	  gateway_toa (tmp, peer->gateway));
   while (1) 
      schedule_wait_for_event (peer->schedule);
   exit (0);
#else
   return;
#endif /* HAVE_LIBPTHREAD */

}


void bgp_schedule_timer (mtimer_t *timer, bgp_peer_t *peer) {

   if (timer == peer->timer_ConnectRetry)
      schedule_event (peer->schedule, bgp_timer_ConnectRetry_fire,
		      2, timer, peer);
   else if (timer == peer->timer_KeepAlive)
      schedule_event (peer->schedule, bgp_timer_KeepAlive_fire,
		      2, timer, peer);
   else if (timer == peer->timer_HoldTime)
      schedule_event (peer->schedule, bgp_timer_HoldTime_fire,
		      2, timer, peer);
   else if (timer == peer->timer_Start)
      schedule_event (peer->schedule, bgp_timer_StartTime_fire,
		      2, timer, peer);
}


void bgp_schedule_socket (bgp_peer_t *peer) {
  select_disable_fd (peer->sockfd); /* delet this? FIXME */
   
  schedule_event (peer->schedule, (void *) bgp_get_pdu, 1, peer);
}


