/* 
 * $Id: select.h,v 1.4 1997/03/21 10:31:45 masaki Exp $
 */

#ifndef _SELECT_H
#define _SELECT_H

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif /* HAVE_SYS_SELECT_H */
#include <linked_list.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */

typedef struct _Descriptor_Struct {
   int marked_for_deletion; /* to be deleted -- masaki */
   int fd;
   int type_mask;
   void (*call_fn)();
   void *arg;
} Descriptor_Struct;


typedef struct _Select_Struct {
  int		interrupt_fd[2];
  pthread_mutex_t     	mutex_lock;
  pthread_t		self;
  fd_set 	fdvar_read;
  fd_set 	fdvar_write;
  fd_set 	fdvar_except;
  LINKED_LIST 	*ll_descriptors;
  trace_t	*trace;
} Select_Struct;



extern Select_Struct *SELECT_MASTER;


/* publich functions */
int select_shutdown ();
int init_select (trace_t *trace);
int select_add_fd (int fd, int type_mask, void (*call_fn)(), void *arg);
int select_delete_fd (int fd);
int mrt_select ();
int select_enable_fd (int fd);

#endif /* _SELECT_H */
