/*
 * $Id: api6.h,v 1.1 1997/03/21 09:11:41 masaki Exp $
 */

#include <config.h>
#ifndef _API6_H
#define _API6_H
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h> /* inet_ntop defined there */

/*
 * The API draft defines only the way to have access in byte.
 * Many implementations provide 32-bit access but the field name may vary.
 */
struct _in6_addr32 {
    u_int _s6_addr32[4];
};

/*
 * These are not defined in the API draft
 */
#define IN6_IS_ADDR_UC_GLOBAL(a) \
    (((a)->s6_addr[0] & 0xe0) == 0x04 || ((a)->s6_addr[0] & 0xe0) == 0x08)

#define IN6_ADDR_COPY(a, b) \
    (*(struct in6_addr *)(a) = *(struct in6_addr *)(b))

#define IN6_ADDR_COMP(a, b) ( \
    (((struct _in6_addr32 *)(a))->_s6_addr32[0] - \
        ((struct _in6_addr32 *)(b))->_s6_addr32[0]) || \
    (((struct _in6_addr32 *)(a))->_s6_addr32[1] -  \
        ((struct _in6_addr32 *)(b))->_s6_addr32[1]) || \
    (((struct _in6_addr32 *)(a))->_s6_addr32[2] -  \
        ((struct _in6_addr32 *)(b))->_s6_addr32[2]) || \
    (((struct _in6_addr32 *)(a))->_s6_addr32[3] -  \
        ((struct _in6_addr32 *)(b))->_s6_addr32[3]))

extern const struct in6_addr in6addr_any;

#ifndef INET6_ADDRSTRLEN
#define INET_ADDRSTRLEN    16
#define INET6_ADDRSTRLEN   46
#endif /* INET6_ADDRSTRLEN */

#ifndef IN6_IS_ADDR_UNSPECIFIED

#define IN6_IS_ADDR_UNSPECIFIED(a) ( \
    ((struct _in6_addr32 *)(a))->_s6_addr32[0] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[1] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[2] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[3] == 0)

#define IN6_IS_ADDR_LOOPBACK(a) ( \
    ((struct _in6_addr32 *)(a))->_s6_addr32[0] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[1] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[2] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[3] == htonl(1))

#define IN6_IS_ADDR_MULTICAST(a) ((a)->s6_addr[0] == 0xff)

/*
 * Some implementations use the space where should be zero,
 * so can't check exactly
 */
#define IN6_IS_ADDR_LINKLOCAL(a) \
    ((a)->s6_addr[0] == 0xfe && ((a)->s6_addr[1] & 0xc0) == 0x80)

#define IN6_IS_ADDR_SITELOCAL(a) \
    ((a)->s6_addr[0] == 0xfe && ((a)->s6_addr[1] & 0xc0) == 0xc0)

#define IN6_IS_ADDR_V4MAPPED(a) ( \
    ((struct _in6_addr32 *)(a))->_s6_addr32[0] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[1] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[2] == htonl(0x0000ffff))

#define IN6_IS_ADDR_V4COMPAT(a) ( \
    ((struct _in6_addr32 *)(a))->_s6_addr32[0] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[1] == 0 && \
    ((struct _in6_addr32 *)(a))->_s6_addr32[2] == 0)

#endif /* IN6_IS_ADDR_UNSPECIFIED */


#ifdef __linux__
#include <netinet6/in6.h>
#include <netinet6/ipv6.h>

#ifndef IPV6_PKTINFO
#define IPV6_PKTINFO IPV6_RXINFO
#endif
#if !defined(CMSG_FIRSTHDR) && defined(CMSG_FIRST)
#define CMSG_FIRSTHDR(a) CMSG_FIRST(a)
#endif

#endif /* __linux__ */

#if !defined(HAVE_INET_NTOP) && defined(HAVE_ADDR2ASCII)

/*
 * MRT uses inet_ntop() defined in draft-ietf-ipngwg-bsd-api-06.txt,
 * which is different from draft-ietf-ipngwg-bsd-api-05.txt, and
 * also different from the old addr2ascii(). At least, BIND 4.9.5 has
 * the expected version of inet_ntop() in its library (libresolv.a).
 */

#define inet_ntop(af, src, dst, size) \
    addr2ascii(af, src, (af==AF_INET)?4:16, dst)

#define inet_pton(af, src, dst) ascii2addr(af, src, dst)

#endif /* !defined(HAVE_INET_NTOP) && defined(HAVE_ADDR2ASCII) */

/*
 * differences in multicast definitions
 */
#ifdef NRL_IPV6
#define ipv6mr_multiaddr i6mr_multiaddr
#define ipv6mr_interface i6mr_interface
#endif /* NRL_IPV6 */
#ifdef __linux__
#define ipv6mr_interface ipv6mr_ifindex
#endif /* __linux__ */

#endif /* _API6_H */
