/*
 * $Id: send_msg.c,v 1.1.1.1 1996/04/09 15:50:35 labovit Exp $
 */ 

/* send_msg: allows testing of the message server by sending a
   user-specified message. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <io.h>

struct assoc {
  char *name;
  enum ARB_MSG_TYPES type;
};

struct assoc enum_assoc[] = {
  { "setmbox", MSG_SETMBOX },
  { "getmbox", MSG_GETMBOX },
  { "clrmbox", MSG_CLRMBOX },
  { "shutdown", MSG_SHUTDOWN },
  { "dump", MSG_DUMP},
  { (char *) NULL, -1 }
};

static void printmsg(ARB_MSG_Struct *msg);
static void cleanup(int qid, int status);

int
main(int argc, char **argv)
{
  int serverq;
  int clientq;
  ARB_MSG_Struct msg;
  struct assoc *p;
  key_t mykey;

  if(argc != 5) {
    fprintf(stderr, "usage: send_msg priority type client_id key\n");
    exit(1);
  }

  mykey = GETKEY();
  if((clientq = msgget(mykey, (0622 | IPC_CREAT))) < 0) {
    perror("client msgget");
    exit(1);
  } else {
    printf("got clientq=%d, mykey=0x%x\n", clientq, mykey);
  }

  if((serverq = msgget(MSGSERVER_KEY, 0222)) < 0) {
    perror("server msgget");
    cleanup(clientq, 1);
  } else {
    printf("got serverq=%d, serverkey=0x%x\n", serverq, MSGSERVER_KEY);
  }

  msg.priority = atol(argv[1]);

  /* sort of a hack */
  for(p = enum_assoc; p->name != NULL && strcmp(p->name, argv[2]) != 0; p++)
    ;
  msg.type = p->type;

  msg.sender = mykey;

  strncpy(msg.mqinfo.client, argv[3], CLIENTLEN);
  msg.mqinfo.key = atol(argv[4]);

  printf("sending message: ");
  printmsg(&msg);

  if(msgsnd(serverq, &msg, sizeof(ARB_MSG_Struct), 0) != 0) {
    perror("msgsnd");
    cleanup(clientq, 1);
  }

  /* this is the only type of message which gets a reply */
  if(msg.type == MSG_GETMBOX) {
    if(msgrcv(clientq, &msg, sizeof(ARB_MSG_Struct), 0, 0) < 0) {
      perror("msgrcv");
      cleanup(clientq, 1);
    }

    printf("received reply: ");
    printmsg(&msg);
  }

  cleanup(clientq, 0);
}

static void
printmsg(ARB_MSG_Struct *msg)
{
  printf("priority=%ld, type=%d, sender=0x%x, client=\"%s\", key=0x%x\n",
	 msg->priority, (int) msg->type, msg->sender, msg->mqinfo.client,
	 msg->mqinfo.key);
}


static void
cleanup(int qid, int status)
{
  /* make sure we remove our queue */
  if(msgctl(qid, IPC_RMID, (struct msqid_ds *) NULL) != 0) {
    perror("msgctl IPC_RMID");
    exit(1);
  }

  exit(status);
}

