#!/usr/local/bin/perl

sub open_IRR_connection {
    local ($server) = @_;
    $AF_INET = 2;
    $SOCK_STREAM = 1; # on solaris, must be 2

    ($name, $aliases, $proto) = getprotobyname("tcp");
    socket(TCP, $AF_INET, $SOCK_STREAM, $proto) || die "socket failed: $!\n";

    # make the socket line-bufffered
    select(TCP); $| = 1; select(stdout);

    ($name, $aliases, $addrtype, $length, @addrs) = gethostbyname($server);

    $saddr = pack($SOCKADDR_IN, $AF_INET, $PORT, $addrs[0]);

    connect(TCP, $saddr) || die "connect failed ($PORT): $!\n";

    if ($DEBUG == 1) {
	print "Connection to $server:$PORT opened\n";
    }
    print TCP "!!\n";
}



sub IRR_command {
    local ($command) = @_;

    print TCP "$command\n";

    $data = "";
    $line = "";
    $line = &read_line;
    if ($line eq "") {
	print "NULLLLLLL\n";
    }
    if (! ($line =~ /^A/)) {return "";}
    

    if ($line =~ /^A(\d+)/) {
	$len = $1;
	$total = 0;

	while ($total < $len) {
	    $buf = "";
	    $rin = $ein = $win = '';
	    vec ($rin, fileno(TCP), 1) = 1;
	    $nfound = select ($rout=$rin, undef, undef, undef);

	    $total += sysread (TCP, $buf, $len - $total);
	    $data .= $buf;
	}
	$line = &read_line;
	if ($line ne "C") {
	    print "Error -- bad return code: $line\n";
	    exit;
	}
	return ("$data");
    }
    else {return "";}
}

sub bitlen {
    local ($mask) = @_;

    $total = 0;
    @byte = split (/\./, $mask);

    foreach $byte (@byte) {
        if ($byte == 255) {$total += 8; next;}
        
        $vector = pack ("C", $byte);
        $bits = unpack ("B*", $vector);
        @bits = split (//, unpack ("B*", $vector));
        foreach $bit (@bits) {
            if ($bit == 1) {$total++;}
            else {last;}
        }
    }
    
    return $total;
}


sub read_line {
    local ($n, $buf);
    $n = 0;
    $buf = "";
    $c = "";

    $rin = $ein = $win = '';
    vec ($rin, fileno(TCP), 1) = 1;
    $nfound = select ($rout=$rin, undef, undef, undef);

    while (($r = sysread (TCP, $c, 1) > 0)) {
        if ($c eq "\n") {return (join ('', $buf));}
	$buf .= $c;
	$c = "";

	$rin = $ein = $win = '';
	vec ($rin, fileno(TCP), 1) = 1;
	$nfound = select ($rout=$rin, undef, undef, undef);
    }
    exit;
}



return 1;
