/*
 * $Id: bgpsim.h,v 1.5 1996/07/26 20:41:56 masaki Exp $
 */

#ifndef _BGPSIM_H
#define _BGPSIM_H

int network_schedule_stability ();
int network_schedule_change ();


typedef struct _network_t {
  int		num;
  prefix_t*	start_prefix;
  prefix_t*	end_prefix;
  LINKED_LIST*  ll_bgp_routes;

  u_int		stability;		/* interval of up/down in seconds */
  u_int		change_interval;	/* interval of change in seconds */
  u_char	flag;			/* 1 = up, 0 = down */

  mtimer_t*	timer_stability;
  mtimer_t*	timer_change;

  int		current;		/* current attrib number */
  int		max;			/* max number of different aspaths etc */
  prefix_t*	nexthops[5];
  aspath_t*	aspaths[5];
  community_t*	communities[5];
  dpa_t*	dpas[5];
  int		localprefs[5];
} network_t;



typedef struct _simulation_t {
  schedule_t *schedule;
  LINKED_LIST *ll_networks;
  LINKED_LIST *ll_aspaths;

  /* stats */
  u_char	on_off;			/* 0 = off */
  u_long	time_start;
  u_long	packets;

  trace_t	*trace;
} simulation_t;

extern simulation_t SIMULATION;







#endif /* _BGPSIM_H */

