#!/usr/local/bin/perl

use MRT;
require "getopt.pl";


&Getopt("f:h:t:");
if (defined $opt_t) { 
    print "Searching on packets after time $opt_t\n";
    ($t_hour, $t_min, $t_sec) = split (/:/, $opt_t);
}



foreach $file (@ARGV) {
    open_mrt_data ($file);

    while (1) {
	($time, $type, $subtype, $length) = &get_mrt_header;

	if ($time == -1) {&done;}

	# get packet
	($srcip, $srcas, $dstip, $dstas, $ann_prefix, $with_prefix, 
	 $aspath, $origin) = 
	     &get_mrt_bgp_msg ($length);

	# count announces and withdraws per peers
	@ann = split (/\s/, $ann_prefix);
	$PEER_ANN{$srcip} += $#ann + 1;

	@with = split (/\s/, $with_prefix);
	$PEER_WITH{$srcip} += $#with + 1;

	# packets per peer
	$PACKETS{$srcip} += 1;

	@as = split (/\s+/, $aspath);
	foreach $as (@as) {
	    $AS{$as} += 1;
	}

	# count distinct routes 
	foreach $a (@ann) {
	    #$ROUTES{$a} += 1;
	    $RTPEER{$srcip}{$a} +=1;
	}
	foreach $a (@with) {
	    #$ROUTES{$a} += 1;
	    $RTPEER{$srcip}{$a} +=1;
	}
    }
}


sub done {

    printf "%-20s %-8s   %-8s   %-8s   %-8s\n", "Peer", "Packets", 
    "Ann", "With", "Prefixes", "Avg Freq";
    foreach $peer (keys (%PACKETS)) {
	@prefixes = keys %{$RTPEER{$peer}};
	$peer = &get_peername ($peer);
	printf "%-20s %-8d   %-8d   %-8d   %-8d\n", 
	$peer, $PACKETS{$peer},
	$PEER_ANN{$peer}, $PEER_WITH{$peer}, $#prefixes + 1;
	$packet_total +=  $PACKETS{$peer};
    }  

    @keys = keys %ROUTES;
    #printf "\n%-8d unique prefixes", $#keys + 1;

    @as = keys %AS;
    printf "\n%-8d unique AS numbers\n", $#as + 1;
    printf "%-8d packets\n", $packet_total;
    exit;
}




sub error {
    print "Usage: decode -f filename [-h host] [-t time]\n";
    exit;
}


