#!/usr/local/bin/perl 

use MRT;
use IRR;

require "getopts.pl";

%origin  = (2, 'Incomplete', 1, 'EGP', 0, 'IGP', 0);

&Getopts('f:ap:s');
if(defined $opt_f) { 
    $IN = $opt_f;
}
if (defined $opt_a) {
    $ASVERBOSE = 1;
}
if (defined $opt_p) {
    $PEER = $opt_p;
}
if (defined $opt_s) {
    $STATS = 1;
}
if (defined $opt_d) {
    $DEBUG = 1;
}

if ($IN eq "") {&error;}

&irr_load_AS_names;
&read_rib ($IN);
&dostats;

exit;

sub read_rib {
    local ($in) = @_;
    
    open (INPUT, $in) || die "Could not open $in: $!\n";

    # version
    $buf = &get (2);
    $version = unpack ("S", $buf);
    if ($version != 1) {
	print "ERROR -- unknown version number $version\n";
	exit;
    }

    # num aspaths
    $buf = &get(2);
    $numaspaths = unpack ("S", $buf);
    if ($STATS == 1) {
	print "$numaspaths distinct ASPATHs\n";
    }

    # aspaths
    while ($numaspaths--) {
	$buf = &get (4);
	($asID, $aslen) = unpack ("SS", $buf);

	$buf = &get ($aslen*2);
	(@aspath) = unpack ("S$aslen", $buf);
	if ($DEBUG == 1) {
	    print "id=$asID len=$aslen @aspath\n";
	}
	$aspath = "@aspath";
	#print "$aspath id=$asID\n";
	$ASPATH{$asID} = $aspath;
    }

    # number of prefixes
    $buf = &get(4);
    $numprefix = unpack ("L", $buf);
    if (($DEBUG == 1) || ($STATS == 1)) {
	print "$numprefix prefixes\n";
    }

    while ($numprefix--) {
	$buf = &get(4);
	@ip = unpack ("C4", $buf);
	$ip = join (".", @ip);
	
	$buf = &get(4);
	($bitlen, $numpeer) = unpack ("SS", $buf);
	$ip = "$ip/$bitlen";

	if ($STATS == 1) {
	    $LEN{$bitlen}++;
	}

	$out = "";
	$out = "$ip\n";

	$flag = 0;
	$unique = 0;
	if ($numpeer == 1) {$unique = 1;}
	while ($numpeer--) {
	    $buf = &get(4);
	    @ip = unpack ("C4", $buf);
	    $ip = join (".", @ip);
	    
	    $buf = &get(8);
	    ($time, $asID, $origin) = unpack ("LSS", $buf);
	    $aspath = $ASPATH{$asID};
	    $origin = $origin{$origin};
	    #print "\t$ip ($aspath) $origin\n";

	    # count of routes per peer
	    if ($STATS == 1) {
		$PEER{$ip}++;
		if ($unique == 1) {
		    $PEERUNIQUE{$ip}++;
		}
	    }

	    if (($PEER ne "") && ($PEER ne $ip)) {next;}
	    $out .= "\t$ip ($aspath) $origin\n";
	    $flag = 1;
	}
	if (($STATS != 1)  && ($flag == 1)) {print $out;}
    }
}



sub get {
    local ($bytes) = @_;
    
    $buf = "";
    if (($n = read (INPUT, $buf, $bytes)) != $bytes) {
	if (($n == 0) && ($bytes == 12)) {return "";}
	print "read $n bytes, expected $bytes\n";
	exit;
    }
    
    $read += $bytes;
    return ($buf);
}


sub error {

    print "Usage: rtdecode.pl -f rib [-p peer] [-s statsfile] [-ad]\n";
    exit;
}

sub mysort {
  $a =~ /([\d\.]+)/;
  $aq = $1; 
  $b =~ /([\d\.]+)/;
  $bq = $1;

   #print "$aq $bq\n";

  @aa = split (/\./, $aq);
  @bb = split (/\./, $bq);

  if ($aa[0] > $bb[0]) {return 1;}
  elsif ($aa[0] <  $bb[0]) {return -1;} 

  if ($aa[1] > $bb[1]) {return 1;}
  elsif ($aa[1] < $bb[1]) {return -1;}

  if ($aa[2] > $bb[2]) {return 1;}
  elsif ($aa[2] < $bb[2]) {return -1;}

  if ($aa[3] > $bb[3]) {return 1;}
  elsif ($aa[3] < $bb[3]) {return -1;}
  
  return 0;
}




sub dostats {
    if ($STATS != 1) {return;}

    print "\n";

    print "Len\tCount\n";
    foreach $len (sort numerically keys %LEN) {
	print "$len\t$LEN{$len}\n";
    }

    print "\n";

    printf "%-15s %-8s   %-8s\n",
    "Peer", "routes", "unique";
    foreach $peer (keys %PEER) {
	$routes = $PEER{$peer} + 0;
	$uroutes = $PEERUNIQUE{$peer} + 0;
	printf "%-15s %-8d    %-8d\n",
	$peer, $routes, $uroutes;
    }
}


sub numerically {$a <=> $b}
