#!/usr/local/bin/perl 

require "syslog.pl";
require "getopt.pl";
use Socket;

$AF_INET     = 2;
#$SOCK_STREAM = 1;	# SunOS
$SOCK_STREAM = 2;	# solaris
$SOCKADDR_IN = "S n a4 x8";
$PORT        = 5556;
$SPOOL_DIR   = "/var/spool/route_servers";

%RS = ('192.157.69.251', 'sprint',
       '198.32.128.131', 'pb',
       '192.41.177.169', 'mae-east',
       '198.32.130.131', 'aads');

&Getopt("p:");
if(defined $opt_p) {
    $PORT = $opt_p;
}

($name, $aliases, $proto) = getprotobyname('tcp');
$this = pack($SOCKADDR_IN, $AF_INET, $PORT, "\0\0\0\0");
select (NS); $| = 1; select (stdout);


$proto = (getprotobyname('tcp'))[2];         
socket(Socket, PF_INET, $SOCK_STREAM, $proto) || 
    die "socket failed here: $!\n";
bind (Socket, $this) || die "Bind failed $!\n";
listen (Socket, 5) || die "listen failed $!\n";

# make the socket line-bufffered
select(Socket); $| = 1; select(stdout);

#&syslog ('info', "rslog started"); 

start:
while (1) {
    $addr = accept (NS,Socket) || die "accept failed $!\n";

    ($af, $port, $inetaddr) = unpack ($SOCKADDR_IN, $addr);
    $addr = join ('.', unpack ('C4', $inetaddr));
    #&syslog ('info', "rslog connection from $addr");
    if ($DEBUG == 1) {print "Connection accepted from $addr\n";}

    # open spool file
    $date = `date \'+%y%m%d\'`;
    $nap = $RS{$addr};
    if ($nap eq "") {
	$nap = $addr;
    }

    $path = "$SPOOL_DIR/$nap";
    if (!(-e $path)) {
	mkdir ("$path", 0777);
    }

    $file = "$path/recv.$date";
    open (DATA, ">> $file");

    stat ($file);
    if (!(-e DATA)) {
	#&syslog ('notice', "Coud not open $file");
	if ($DEBUG == 1) {print "Could not open $file";}
    }

    $bytes = 0;
    $packets = 0;

    # read header
    while (read (NS, $buf, 12)  == 12) {
	$total = 0; $out = ""; $packets ++;
	# MRT message header: time 4 | type 2 | subtype 2 | length 4
	($time, $type, $subtype, $length) = unpack ("LSSL", $buf);
	$out .= $buf;
	print "$time $type $subtype $length\n";

	# read message
	while ($total < $length) {
	    if (read (NS, $buf, 1) != 1) {
		#&syslog ('notice', "read failed from $addr");
		if ($DEBUG == 1) {
		    print "read failed from $addr";
		}
		goto end;
	    }
	    $total += 1;
	    $out .= $buf;
	}
	print DATA $out; # write message to disk
	$bytes += $total;


    }

end:
    #&syslog ('info', "$bytes bytes/$packets packets copied to $file");
    if ($DEBUG == 1) {print "$bytes bytes/$packets packets copied to $file";}

    close (DATA);
    close (NS);
}

