#!/usr/local/bin/perl
#
# $Id: gatedsend.pl,v 1.1 1996/06/20 20:30:44 labovit Exp $
#
# Name:    gatedsend.pl
# Author:  Craig Labovitz (Merit Network, Inc.) <labovit@merit.edu>
# Version: 1.0 (2/26/96)
# Description:
#   Munge log file created by RSd (GateD varient) and send of periodic
#   binary MRT messages updates to a server. Keep an track of where we are
#   in the log file in an offset file (usually /tmp/mrt.offset).
# 
# TODO ability to cycle ports if one server/port is unreachable/busy
#      alarm to kill us off if we take too long
#

require "timelocal.pl";
require "getopt.pl";

$GATEDLOG = "/var/spool/gated/gatedlog";
#$GATEDLOG = "./gatedlog";
$OFFSET   = "/tmp/mrt.offset";
$SERVER   = "compute.merit.edu";
$PORT     = 6557;

%MONTHS   = ('Jan', 0, 'Feb', 1, 'Mar', 2, 'Apr', 3, 'May', 4, 
	     'Jun', 5, 'Jul', 6, 'Aug', 7, 'Sep', 8, 'Oct', 9,
	     'Nov', 10, 'Dec', 11);
$DEBUG    = 0;

# catch signals
$SIG{'PIPE'} = 'handler';
$SIG{'QUIT'} = 'handler';
$SIG{'INT'} = 'handler';

if ($DEBUG) {open (OUT, ">/tmp/out");}


%origin  = ('Incomplete', 2, 'EGP', 1, 'IGP', 0);
$in_bgp_recv   = 0;

# options
&Getopt("p:h:");
if(defined $opt_p) {
    $PORT = $opt_p;
}
if(defined $opt_h) {
    $SERVER = $opt_h;
}


&read_offset;
&open_log_connection;
$YEAR = &getyear;

# log has switched on us -- read old one first
if ($lastoffset != 0) {
    &read_gated ("$GATEDLOG.0", $lastoffset);
}
&read_gated ("$GATEDLOG", $offset);
&write_offset;

exit;


sub read_gated {
    local ($LOG, $offset) = @_;
    #my $month, $mday, $hour, $min, $sec, $src, $dst;

    if (open (GATEDLOG, $LOG) < 1) {
	print "Could not open $LOG\n";
	return;
    }
    if (seek (GATEDLOG, $offset, 0) != 1) {die "Seek failed $!";}

    $line = 0;
    while (<GATEDLOG>) {
	$line++;
	if (/new state Established/) {
	    $_ =~ /peer\s+([\d\.]+)/;
	    &print_mrt_peer_dead (time, $1);
	    next;
	}
	if (/trace_on/) {next;}

	if (/BGP RECV/) {
	    if (/(\w+)\s+(\d+)\s+(\d+):(\d+):(\d+)\s+BGP RECV\s([\d\.]+)\+\d+\s-\>\s([\d\.]+).*/) {
		$month = $MONTHS{$1};
		$mday = $2;
		$hour = $3;
		$min = $4;
		$sec = $5;
		$src = $6;
		$dst = $7;
		$in_bgp_recv = 1;
		/^(\w+)\s(\d+)\s(\d+):(\d+):(\d+)\s.*/;
		next;
	    }
	    elsif ($in_bgp_recv != 1) {
		print "error here (line $line) $_\n";
	    }
	    elsif (/2 bytes/) {;} #NOOP -- notification received
	    elsif (/BGP\sRECV\sversion/) {;} #NOOP
	    elsif (/BGP\sRECV\sNotification/) {;} #NOOP
	    elsif (/message\stype\s(\d+)\s.*/) {$msg = $1;}
	    elsif (/Origin\(1\):\s+(\w+).*/) { $attr[$nattr++] = "origin $1";}
	    elsif (/ASPath\(2\):\s+([\d\s]+).*/) {$attr[$nattr++] = "aspath $1";}
	    elsif (/Unreachable/) {$unreachable = 1;}
	    elsif (/BGP\sRECV\s+([\d\.\/\,\s]+).*/) {$routes .= $1;}
	    elsif (/NextHop\(3\):\s([\d\.]+).*/) {$attr[$nattr++] = "nexthop $1";}
	    elsif (/MultiExitDisc\(4\):\s(\d+).*/) {$attr[$nattr++] = "multiexit $1";}
	    elsif (/Atomic_Aggregate\(6\).*/) {$attr[$nattr++] = "atomic_aggregate";}
	    elsif (/Aggregator\(7\):\s([\w\d\s\.]+).*/) {$attr[$nattr++] = "aggregator $1";}
	    else {print "error\n$_"; exit;}
	}
	elsif ($in_bgp_recv == 1) {
	    $in_bgp_recv = 0;
	    # only build packets for update messages
	    if ($msg == 2) {
		if ($unreachable == 1) { 
		    &build_packet_withdraw ($month, $mday, $hour, $min, $sec);
		} else {
		    &build_packet_announce ($month, $mday, $hour, $min, $sec);
		}
		$packets ++;
		#if ($packets == 2048) {exit;}
	    }
	    &reset_bgp_recv;
	}
    }
}

sub reset_bgp_recv {
    $in_bgp_recv = 0;
    $src = "";
    $dst = "";
     $unreachable = 0;
     $routes = "";
    $msg = "";
    @attr = "";
    $nattr = 0;
}


sub build_packet_withdraw {
    local ($month, $mday, $hour, $min, $sec) = @_;
    
    $time = &gettime ($month, $mday, $hour, $min, $sec);
    $length = 0;  #to be determined
    $totalwithbyte;

    $routes =~ s/[,\s\n]+/ /g;
    @routes = split (/\s+/, $routes);

    $totalwithbyte = 0;
    $withdata = "";
    $count = 0;

    # withdraw size calculations
    foreach $route (@routes) {
	($prefix, $length) = split (/\//, $route);
	$byte = &bytes ($length);
	$totalwithbyte += ($byte + 1);
    }

    $length = 12 + 2 + $totalwithbyte + 2;

    # MRT MSG header
    &print_mrt_header ($time, $length, $src, $dst);

    # withdraw routes
    if ($DEBUG) {print OUT pack ("S1", $totalwithbyte);}
    print TCP pack ("S1", $totalwithbyte);
     foreach $route (@routes) {
	($prefix, $length) = split (/\//, $route);
	@prefix = split (/\./, $prefix);
	$byte = &bytes ($length);
	if ($DEBUG) { print OUT pack ("C1C$byte", $length, @prefix);}
	print TCP pack ("C1C$byte", $length, @prefix);
    }

    # total path attributes field
    if ($DEBUG) {print OUT pack ('C2', 0);}
    print TCP pack ('C2', 0);
}


sub print_mrt_header {
    local ($time, $length, $src, $dst) = @_;
    $type = 5;    #BGP
    $subtype = 1; #update

    @src = split (/\./, $src);
    @dst = split (/\./, $dst);
    if ($DEBUG) {
	print OUT pack ("NnnN", $time, $type, $subtype, $length);
	print OUT pack ('SC4', 0, @dst);
	print OUT pack ('SC4', 0, @src);
    }

    print TCP pack ("NnnN", $time, $type, $subtype, $length);
    print TCP pack ('SC4', 0, @src);
    print TCP pack ('SC4', 0, @dst);
    #print "time = $time\n";
}

sub print_mrt_peer_dead {
    local ($time, $peer) = @_;
    $type = 5;    #BGP
    $subtype = 3; #peer dead

    @peer = split (/\./, $peer);

    print TCP pack ("NnnN", $time, $type, $subtype, 6);
    print TCP pack ('SC4', 0, @peer);
}
    

sub build_packet_announce {
    local ($month, $mday, $hour, $min, $sec) = @_;

    $time = &gettime ($month, $mday, $hour, $min, $sec);
    $length = 0;  #to be determined
    $nlri_byte = 0;

    $routes =~ s/[,\s\n]+/ /g;
    @routes = split (/\s+/, $routes);

    #path attributes
    $totalattrib_length = 0;

    foreach $attr (@attr) {
	($type, @value) = split (/\s+/, $attr);
	if ($type eq "origin") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length
	    $totalattrib_length += 1; #value
	}
	if ($type eq "nexthop") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length
	    $totalattrib_length += 4; #ip address
	}
	elsif ($type eq "aspath") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length

	    $totalattrib_length += 1; # segment type (sequence)
	    $totalattrib_length += 1; # length
	    $totalattrib_length += 2 * ($#value + 1);
	}
	elsif ($type eq "multiexit") {  
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length 
	    $totalattrib_length += 4; #value 
	}
	elsif ($type eq "atomic_aggregate") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length 
	    $totalattrib_length += 0; #value 
	}
	elsif ($type eq "aggregator") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length 
	    $totalattrib_length += 6; #value 
	}
    }


    # nlri calculations
    foreach $route (@routes) {
	($prefix, $length) = split (/\//, $route);
	$byte = &bytes ($length);
	$nlri_byte += (1 + $byte);
	#print "$prefix $byte\n";
    }


    $length = 12 + 2 + 2 + $totalattrib_length + $nlri_byte;

    # MRT MSG header
    &print_mrt_header ($time, $length, $src, $dst);

    # total withdrawn routes field
    if ($DEBUG) {print OUT pack ('C2', 0);}
    print TCP pack ('C2', 0);

    # total path attribute length
    if ($DEBUG == 1) {print OUT pack ('S', $totalattrib_length);}
    print TCP pack ('S', $totalattrib_length);

    # path attributes 
    foreach $attr (@attr) {
	($type, @value) = split (/\s+/, $attr);
	if ($type eq "origin") {
	    #print "$value[0] $origin{$value[0]}\n";
	    #attr-flag | attr_type_code | length
 	    print TCP pack ("C1C1C1", 0x40, 1, 1); 
	    print TCP pack ("C1", $origin{$value[0]});      # origin
	    if ($DEBUG == 1) {
		print OUT pack ("C1C1C1", 0x40, 1, 1);
		print OUT pack ("C1", $origin[$value[0]]);      # origin
	    }
	}
	elsif ($type eq "aspath") {
	    print TCP pack ("C1C1", 0x40, 2); #attr-flag! attr_type_code
	    print TCP pack ("C1", 2 + 2*($#value + 1)); # length
	    print TCP pack ("C1", 2);      # sequence
	    print TCP pack ("C1", ($#value + 1)); # num as's
	    if ($DEBUG == 1)  {
		print OUT pack ("C1C1", 0x40, 2); #attr-flag! attr_type_code
		print OUT pack ("C1", 2 + 2*($#value + 1)); # length
		print OUT pack ("C1", 2);      # sequence
		print OUT pack ("C1", ($#value + 1)); # num as's
	    }
	    foreach $as (@value) {
		if ($DEBUG == 1) {print OUT pack ("S", $as);}
		print TCP pack ("S", $as);
	    }
	}
	elsif ($type eq "nexthop") {
	    @addr = split (/\./, $value[0]);
	    #attr-flag | attr_type_code | length
	    if ($DEBUG) {
		print OUT pack ("C1C1C1", 0x40, 3, 4);
		print OUT pack ("C4", @addr);
	    }
	    print TCP pack ("C1C1C1", 0x40, 3, 4);
	    print TCP pack ("C4", @addr);
	}
	elsif ($type eq "multiexit") {
	    @addr = split (/\./, $value[0]);
	    #attr-flag | attr_type_code | length
	    if ($DEBUG) {
		print OUT pack ("C1C1C1", 0x80, 3, 4);
		print OUT pack ("N", $value[0]);
	    }
	    print TCP pack ("C1C1C1", 0x40, 4, 4);
	    print TCP pack ("N", $value[0]);
	}
	elsif ($type eq "atomic_aggregate") {
	    #attr-flag | attr_type_code | length
	    if ($DEBUG) {
		print OUT pack ("C1C1C1", 0x40, 6, 0);
	    }
	    print TCP pack ("C1C1C1", 0x40, 6, 0);
	}
	elsif ($type eq "aggregator") { 
	    @addr = split (/\./, $value[1]);
	    #attr-flag | attr_type_code | length
	    if ($DEBUG) {
		print OUT pack ("C1C1C1", 0xc0, 7, 6);
		print OUT pack ("SC4", $value[0], @addr);
	    }
	    print TCP pack ("C1C1C1", 0xc0, 7, 6);
	    print TCP pack ("SC4", $value[0], @addr);
	}
    }
    
    # add nlri
     foreach $route (@routes) {
	($prefix, $length) = split (/\//, $route);
	@prefix = split (/\./, $prefix);
	$byte = &bytes ($length);
	if ($DEBUG == 1) { print OUT pack ("C1C$byte", $length, @prefix);}
	print TCP pack ("C1C$byte", $length, @prefix);
    }
}


# someday I will learn how to do integer division in perl... (sigh)
sub bytes {
    local ($length) = @_;

    if ($length <= 8) { return (1);}
    if ($length <= 16) {return (2);}
    if ($length <= 24) {return (3);}
    
    return (4);
}


# open connection to logging host
sub open_log_connection {
    $AF_INET = 2;
    $SOCK_STREAM = 1;
    $SOCKADDR_IN = "S n a4 x8";

    ($name, $aliases, $proto) = getprotobyname("tcp");

    #socket(TCP, PF_INET, SOCK_STREAM, $proto) || die "socket failed: $!\n";
    socket(TCP, $AF_INET, 1, $proto) || die "socket failed: $!\n";

    # make the socket line-bufffered
    select(TCP); $| = 1; select(stdout);

    ($name, $aliases, $addrtype, $length, @addrs) = gethostbyname($SERVER);

    if ($DEBUG == 1) {
	print "Trying $PORT port\n";
    }
    $saddr = pack($SOCKADDR_IN, $AF_INET, $PORT, $addrs[0]);

    if (connect(TCP, $saddr) >= 0) {
	if ($DEBUG==1) {print "Connection to $SERVER:$PORT opened\n";}
	return;
    }

    # argh! we failed
    shutdown (TCP, 0);

    print "connect to $Server failed: $!\n";
    exit;
}



sub write_offset {
    open (OFFSET, "> $OFFSET") || die "Could not open $OFFSET\n";

    # get new gatedsize since last reading
    $gatedsize = (-s $GATEDLOG);
    print OFFSET "$gatedsize";
}


sub handeler {
    local ($sig) = @_;

    print "Caught signal SIG$sig -- exiting.\n";
    &write_offset;
    exit;
}


sub gettime {
    local ($month, $mday, $hours, $min, $sec) = @_;

    #print "$month, $mday, $hours, $min, $sec\n";
    $out = &timelocal($sec,$min,$hours,$mday,$month, $YEAR);
    #print "$hours $minc $sec $out\n";    
    return ($out);
}


sub getyear {
    local ($year);

    ($a1, $a2, $a3, $a4, $a5, $year, @junk) = localtime (time);
    return ($year);
}


sub read_offset {
    $offset = 0;
    $lastoffset = 0;

    if (-r $OFFSET) {
	open (OFFSET, $OFFSET);
	<OFFSET> =~ /(\d+)/;
	$offset = $1;
    } 
    else {
	print "No $OFFSET file -- starting from beginning\n";
	$offset = 0;
	return;
    }

    $gatedsize = (-s $GATEDLOG);

    if ($gatedsize == 0) {
	print "Zero size $GATEDLOG\n";
	exit;
    }
    if (($gatedsize < $offset) && ($offset > 0)) {
	print "Logfile has changed -- starting from beginning\n";
	$lastoffset = $offset; $offset = 0;
	return;
    }
    if ($gatedsize == $offset) {
	print "No work to be done\n";
	print "offset $offset == size of gated file ($gatedsize)\n";
	exit;
    }
}
