#!/usr/local/bin/perl

require "getopt.pl";

%origin  = (2, 'Incomplete', 1, 'EGP', 0, 'IGP', 0);

&Getopt("f:h:t:");
if(defined $opt_f) { $INPUT = $opt_f;}
if (defined $opt_h) { 
    print "Searching for packets from $opt_h\n";
    $HOST = $opt_h;
}
if (defined $opt_t) { 
    print"Searching on packets after time $opt_t\n";
    ($t_hour, $t_min, $t_sec) = split (/:/, $opt_t);
}


if ($INPUT eq "") {&error;}



open (INPUT, "$INPUT") || die "Could not open $INPUT $!\n";


while ($buf = &get(12)) {
    ($time, $type, $subtype, $length) = unpack ("NnnN", $buf);

    if (($type != 5) || ($subtype != 1)) {
	&get ($length);
	#print "$length skip\n";exit;
	next;
    }
    #print "$type $subtype\n";

    #print "time=$time type=$type subtype=$subtype len=$length\n";
    ($sec, $min, $hour, $mday, $mon, $year, @junk) = localtime ($time);
    $mon++;
    
    # search on time
    if (($hour < $t_hour) || 
	(($hour == $t_hour) && ($min < $t_min))) {
	&get ($length);
	next;
    }
    if ($hour < 10) {$hour = "0$hour";}
    if ($min < 10) {$min = "0$min";}
    if ($sec < 10) {$sec = "0$sec";}
    $title = "\nTIME: $mon/$mday/$year $hour:$min:$sec\n";
    decode_bgp ($length);
}


sub decode_bgp {
    local ($size, $data) = @_;
    $read = 0;

    $buf = &get (6);
    ($srcas, @srcip) = unpack ("SC4", $buf);
    $srcip = join ('.', @srcip);


    if (($HOST ne "") && ($HOST ne $srcip)) {
	&get ($length - 6);
	return;
    }
	
    print $title;
    print "FROM: $srcip AS$srcas\n";

    $buf = &get (6);
    ($dstas, @dstip) = unpack ("SC4", $buf);
    $dstip = join ('.', @dstip);
    print "TO: $dstip AS$dstas\n";

    $buf = &get (2);
    $totalwithbyte = unpack ("S", $buf);
    #print "totalwith = $totalwithbyte\n";

    while ($totalwithbyte > 0) {
	$buf = &get(1);
	$bitlen = unpack ("C1", $buf);
	$bytes = &bytes ($bitlen);
	$buf = &get ($bytes);
	@addr = unpack ("C$bytes", $buf);
	$addr = join ('.', @addr);
	print "  $addr/$bitlen\n";
	$totalwithbyte -= (1 + $bytes);
    }


    # total path attributes field
    $buf = &get (2);
    $total = unpack ('S', $buf);
    #print "total = $total\n"; 

    while ($total > 0) {
	#attr-flag | attr_type_code | length
	$buf = &get (3);
	($flag, $type, $alen) = unpack ("C3", $buf);
	$total -= 3;
	$total -= $alen;

	if ($type == 1) {
	    $buf = &get(1);
	    $org = unpack ("C", $buf);
	    print "ORIGIN: $origin{$org}\n";
	}
	elsif ($type == 2) {

	    print "ASPATH: ";
	    while ($alen > 0) {
		$buf = &get (2);
		($seg_type, $seg_len) = unpack ("CC", $buf);
		$alen -= 2;

		while ($seg_len-- > 0) {
		    $buf = &get (2);
		    $alen -= 2;
		    $as = unpack ("S", $buf);
		    print "$as ";
		}
	    }
	    print "\n";
	}
	elsif ($type == 3) {
	    $buf = &get (4);
	    @addr = unpack ("C4", $buf);
	    $addr = join ('.', @addr);
	    print "NEXT HOP: $addr\n";
	}
	else {
	    print "unknown attribute $type\n";
	    exit;
	}
    }

    #print "read $read size $size\n";

    if ($read < $size) {
	print "ANNOUNCE\n";
    }
    while ($read < $size) {
	$buf = &get (1);
	$length = unpack ("C", $buf);
	#print "length = $length $read\n";exit;

	$bytes = &bytes ($length);
	$buf = &get ($bytes);
	@addr = unpack ("C$bytes", $buf);
	$addr = join ('.', @addr);
	print "  $addr/$length\n";
    }
}




sub print_mrt_header {
    local ($time, $length, $src, $dst) = @_;
    $type = 5;    #BGP
    $subtype = 1; #update

    @src = split (/\./, $src);
    @dst = split (/\./, $dst);
    if ($DEBUG) {
	print OUT pack ("NnnN", $time, $type, $subtype, $length);
	print OUT pack ('SC4', 0, @src);
	print OUT pack ('SC4', 0, @dst);
    }

    print TCP pack ("NnnN", $time, $type, $subtype, $length);
    print TCP pack ('SC4', 0, @src);
    print TCP pack ('SC4', 0, @dst);

}
    

sub build_packet_announce {
    $time = time ();
    $length = 0;  #to be determined
    $nlri_byte = 0;

    $routes =~ s/[,\s\n]+/ /g;
    @routes = split (/\s+/, $routes);

    #path attributes
    $totalattrib_length = 0;

    foreach $attr (@attr) {
	($type, @value) = split (/\s+/, $attr);
	if ($type eq "origin") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length
	    $totalattrib_length += 1; #value
	}
	if ($type eq "nexthop") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length
	    $totalattrib_length += 4; #ip address
	}
	elsif ($type eq "aspath") {
	    $totalattrib_length += 2; #attr-flag! attr_type_code
	    $totalattrib_length += 1; #length

	    $totalattrib_length += 1; # segment type (sequence)
	    $totalattrib_length += 1; # length
	    $totalattrib_length += 2 * ($#value + 1);
	}
    }


    # nlri calculations
    foreach $route (@routes) {
	($prefix, $length) = split (/\//, $route);
	$byte = &bytes ($length);
	$nlri_byte += (1 + $byte);
	#print "$prefix $byte\n";
    }


    $length = 12 + 2 + 2 + $totalattrib_length + $nlri_byte;

    # MRT MSG header
    &print_mrt_header ($time, $length, $src, $dst);

    # total withdrawn routes field
    if ($DEBUG) {print OUT pack ('C2', 0);}
    print TCP pack ('C2', 0);

    # total path attribute length
    if ($DEBUG == 1) {print OUT pack ('S', $totalattrib_length);}
    print TCP pack ('S', $totalattrib_length);

    # path attributes 
    foreach $attr (@attr) {
	($type, @value) = split (/\s+/, $attr);
	if ($type eq "origin") {
	    #attr-flag | attr_type_code | length
 	    print TCP pack ("C1C1C1", 0, 1, 1); 
	    print TCP pack ("C1", $origin[$value[0]]);      # origin
	    if ($DEBUG == 1) {
		print OUT pack ("C1C1C1", 0, 1, 1);
		print OUT pack ("C1", $origin[$value[0]]);      # origin
	    }
	}
	elsif ($type eq "aspath") {
	    print TCP pack ("C1C1", 0, 2); #attr-flag! attr_type_code
	    print TCP pack ("C1", 2 + 2*($#value + 1)); # length
	    print TCP pack ("C1", 2);      # sequence
	    print TCP pack ("C1", ($#value + 1)); # num as's
	    if ($DEBUG == 1)  {
		print OUT pack ("C1C1", 0, 2); #attr-flag! attr_type_code
		print OUT pack ("C1", 2 + 2*($#value + 1)); # length
		print OUT pack ("C1", 2);      # sequence
		print OUT pack ("C1", ($#value + 1)); # num as's
	    }
	    foreach $as (@value) {
		if ($DEBUG == 1) {print OUT pack ("S", $as);}
		print TCP pack ("S", $as);
	    }
	}
	elsif ($type eq "nexthop") {
	    @addr = split (/\./, $value[0]);
	    #attr-flag | attr_type_code | length
	    if ($DEBUG) {
		print OUT pack ("C1C1C1", 0, 3, 4);
		print OUT pack ("C4", @addr);
	    }
	    print TCP pack ("C1C1C1", 0, 3, 4);
	    print TCP pack ("C4", @addr);
	}
    }

    # add nlri
     foreach $route (@routes) {
	($prefix, $length) = split (/\//, $route);
	@prefix = split (/\./, $prefix);
	$byte = &bytes ($length);
	if ($DEBUG == 1) { print OUT pack ("C1C$byte", $length, @prefix);}
	print TCP pack ("C1C$byte", $length, @prefix);
    }
}


# someday I will learn how to do integer division in perl... (sigh)
sub bytes {
    local ($length) = @_;

    if ($length <= 8) { return (1);}
    if ($length <= 16) {return (2);}
    if ($length <= 24) {return (3);}
    
    return (4);
}


# open connection to logging host
sub open_log_connection {
    $AF_INET = 2;
    $SOCK_STREAM = 1;
    $SOCKADDR_IN = "S n a4 x8";

    ($name, $aliases, $proto) = getprotobyname("tcp");

    #socket(TCP, PF_INET, SOCK_STREAM, $proto) || die "socket failed: $!\n";
    socket(TCP, $AF_INET, $SOCK_STREAM, $proto) || die "socket failed: $!\n";

    # make the socket line-bufffered
    select(TCP); $| = 1; select(stdout);

    ($name, $aliases, $addrtype, $length, @addrs) = gethostbyname($SERVER);

    $saddr = pack($SOCKADDR_IN, $AF_INET, $PORT, $addrs[0]);

    if (connect(TCP, $saddr) != 1) {
	print "connect to $Server failed: $!\n";
	exit;
    }

    if ($DEBUG) {print "Connection to $SERVER:$PORT opened\n";}
    #print TCP "!!\n";
}




sub write_offset {
    open (OFFSET, "> $OFFSET") || die "Could not open $OFFSET\n";

    # get new gatedsize since last reading
    $gatedsize = (-s $GATEDLOG);
    print OFFSET "$gatedsize";
}


sub handeler {
    local ($sig) = @_;

    print "Caught signal SIG$sig -- exiting.\n";
    &write_offset;
    exit;
}



sub get {
    local ($bytes) = @_;
    
    $buf = "";
    if (($n = read (INPUT, $buf, $bytes)) != $bytes) {
	if (($n == 0) && ($bytes == 12)) {exit;}
	print "read $n bytes, expected $bytes\n";
	exit;
    }
    
    $read += $bytes;
    return ($buf);
}


sub error {
    print "Usage: decode -f filename [-h host] [-t time]\n";
    exit;
}
