#!/usr/local/bin/perl

use GD;

# map coordiantes to draw US map
$MAPFILE = "./us-map";

# image size
$HEIGHT = 420;
$WIDTH = 900;

%CITIES= ('Chicago', '42.2 88.15',  # *AADS*
	  'SanFrancisco', '38.07 122.00',  # *PacBell*
	  'WillowSprings', '39.86 93.90', # Illinois 
	  'Washington', '38.20 76.68',
	  #'NorthRoyalton', '41.2 82.15',
	  'NorthRoyalton', '41.2 81.15', # Ohio
	  'Pennsauken', '40.50 74.28', # NJ *SPRINT NAP *
	  'WestOrange', '39.50 74.28'); #NJ

@NAP_CITIES = ('Chicago AADS', 'SanFrancisco PacBell',
	       'Washington Mae-East', 'Pennsauken Sprint');

&init;
&parse_map_file;
$im->fill(0, 0,$lightblue);
&draw_cities;
&draw_naps;

$im->string (gdLargeFont, 5, $HEIGHT-50, "Network MCI ($DATE)", $red);

# draw MCI mae-east to mae-west path
&draw_link ("Chicago", "Washington");
&draw_link ("SanFrancisco", "Chicago");
&draw_link ("WestOrange", "Washington");
&draw_link ("WestOrange", "Pennsauken");

# draw MCI sprint to pb path
&draw_link ("Pennsauken", "WestOrange");
&draw_link ("SanFrancisco", "WestOrange");

# draw MCI sprint to aads
draw_link ("Pennsauken", "WillowSprings");
draw_link ("WestOrange", "WillowSprings");
draw_link ("WillowSprings", "Chicago");



open (OUT, "> ./map.gif");
print OUT $im->gif;

exit;


sub parse_map_file {
    @vert = ();
    open (MAP, "$MAPFILE") || die "Could not open $MAPFILE : $!\n";
    while (<MAP>) {
	if (/^[A-Za-z]/) {
	    print $_;
	    $state = "$1";
	    $count = <MAP>;
	    if ($#vert != -1) { &draw_state ($state, @vert); }
	    @vert = ();
	}
	else {
	    chop;
	    push (@vert, $_);
	}
    }
}



sub draw_naps {
    foreach $nap_entry (@NAP_CITIES) {
	($city, $name) = split (/\s/, $nap_entry);

	$point = $CITIES{$city};
	($y, $x) = split (/\s/, $point);
	$x = &x($x);
	$y = &y($y);
	$im->filledRectangle($x-4,$y-4,$x+4,$y+4,$red);
	#$im->arc($x,$y,12,12,0,360,$red);
	#$im->fill($x+2,$y+2,$red);
	print "NAP $city $x $y\n";
	$im->string (gdSmallFont, $x+5, $y+5, "$name", $red);
    }
}


sub draw_cities {
    foreach $city (keys %CITIES) {

	$skip = 0;

	foreach $nap_entry (@NAP_CITIES) {
	    ($c, $n) = split (/\s/, $nap_entry);
	    if ($c eq $city) {
		$skip = 1;
		last;
	    }
	}

	if ($skip == 1) {next;}
	
	$point = $CITIES{$city};
	($y, $x) = split (/\s/, $point);
	$x = &x($x);
	$y = &y($y);
	$im->arc($x,$y,12,12,0,360,$blue);
	$im->string (gdSmallFont, $x+5, $y+5, "$city", $blue);
	print "$city $x $y\n";
    }
}


# allocate image and colors 
sub init {
    $DATE	= `date \'+%h %d, 19%y %H:%M:%S\'`; chop ($DATE);
    $im = new GD::Image ($WIDTH, $HEIGHT);

    $white = $im->colorAllocate (255,255,255);
    $black = $im->colorAllocate (0,0,0);
    $red = $im->colorAllocate (255, 0,0);
    $blue =  $im->colorAllocate (0,0,255);
    $lightblue =  $im->colorAllocate (191,239,255);
    $green = $im->colorAllocate (0,100,0);
    $yellow = $im->colorAllocate (255, 255, 0);
    $violet = $im->colorAllocate (186, 85, 211);
	
    #$im->transparent($white);
    $im->interlaced('true');
} 



sub draw_state {
    local ($name, @vertices) = @_;

    $poly = new GD::Polygon;
    $fx = 0;
    $fy = 0;
    foreach $vert (@vertices) {
	($y, $x) = split (/\s/, $vert);
	$x = &x($x);
	$y = &y($y);
	if ($fx != 0) {
	    $im->line ($x, $y, $fx, $fy, $black);
	}
	$fx = $x;
	$fy = $y;
    }
}



sub x {
    local ($x) = @_;
    
    return ((1100 - $x*15) + 800);
}


sub y {
    local ($y) = @_;
    
    return ((800 - $y*16) + 0);
}
    


# draw a link between two cities
sub draw_link {
    local ($city1, $city2) = @_;

    if ($CITIES{$city1} eq "") {
	print "No $city1\n";
	return;
    }
    if ($CITIES{$city2} eq "") {
	print "No $city2\n";
	return;
    }

    $point = $CITIES{$city1};
    ($y, $x) = split (/\s/, $point);
    $x1 = &x($x); 
    $y1 = &y($y);

    $point = $CITIES{$city2};
    ($y, $x) = split (/\s/, $point);
    $x2 = &x($x);
    $y2 = &y($y);

    print "LINK $city2 $x2 $y2 --- $city1 $x1 $y1\n";
    
    $im->line ($x1, $y1, $x2, $y2, $red);
}
