#!/usr/local/bin/perl
#
# $Id: route_btoa.pl,v 1.5 1996/11/21 17:35:23 labovit Exp $
#
# Name:    route_btoa.pl
# Author:  Craig Labovitz (Merit Network, Inc.) <labovit@merit.edu>
#  A perl version of route_btoa
#

require "getopts.pl";

%origin  = (2, 'Incomplete', 1, 'EGP', 0, 'IGP', 0);

&Getopts("f:i:");
if(defined $opt_f) { $INPUT = $opt_f;}
if(defined $opt_i) { $INPUT = $opt_i;}
if ($INPUT eq "") {&error;}


open (INPUT, "$INPUT") || die "Could not open $INPUT $!\n";


while ($buf = &get(12)) {
    ($time, $type, $subtype, $length) = unpack ("NnnN", $buf);

    if (($type != 5) || ($subtype != 1)) {
	&get ($length);
	#print "$length skip\n";exit;
	next;
    }
    #print "$type $subtype\n";

    #print "time=$time type=$type subtype=$subtype len=$length\n";
    ($sec, $min, $hour, $mday, $mon, $year, @junk) = localtime ($time);
    $mon++;
    
    # search on time
    if (($hour < $t_hour) || 
	(($hour == $t_hour) && ($min < $t_min))) {
	&get ($length);
	next;
    }
    if ($hour < 10) {$hour = "0$hour";}
    if ($min < 10) {$min = "0$min";}
    if ($sec < 10) {$sec = "0$sec";}
    $title = "TIME: $mon/$mday/$year $hour:$min:$sec\n";
    decode_bgp ($length);
}


sub decode_bgp {
    local ($size, $data) = @_;
    $read = 0;

    $buf = &get (6);
    ($srcas, @srcip) = unpack ("SC4", $buf);
    $srcip = join ('.', @srcip);


    if (($HOST ne "") && ($HOST ne $srcip)) {
	&get ($length - 6);
	return;
    }
	
    print "\nTYPE: BGP/UPDATE\n";
    print $title;
    if ($srcas !=0) {print "FROM: $srcip AS$srcas\n";}

    $buf = &get (6);
    ($dstas, @dstip) = unpack ("SC4", $buf);
    $dstip = join ('.', @dstip);
    if ($dstas !=0) {print "TO: $dstip AS$dstas\n";}

    $buf = &get (2);
    $totalwithbyte = unpack ("S", $buf);
    #print "totalwith = $totalwithbyte\n";

    if ($totalwithbyte > 0) {
	print "WITHDRAW:\n";
    }

    while ($totalwithbyte > 0) {
	$buf = &get(1);
	$bitlen = unpack ("C1", $buf);
	$bytes = &bytes ($bitlen);
	$buf = &get ($bytes);
	@addr = unpack ("C$bytes", $buf);
	$addr = join ('.', @addr);
	print "  $addr/$bitlen\n";
	$totalwithbyte -= (1 + $bytes);
    }


    # total path attributes field
    $buf = &get (2);
    $total = unpack ('S', $buf);
    #print "total = $total\n"; 

    while ($total > 0) {
	#attr-flag | attr_type_code | length
	$buf = &get (3);
	($flag, $type, $alen) = unpack ("C3", $buf);
	$total -= 3;
	$total -= $alen;

	if ($type == 1) {
	    $buf = &get(1);
	    $org = unpack ("C", $buf);
	    print "ORIGIN: $origin{$org}\n";
	}
	elsif ($type == 2) {

	    print "ASPATH: ";
	    while ($alen > 0) {
		$buf = &get (2);
		($seg_type, $seg_len) = unpack ("CC", $buf);
		$alen -= 2;

		if ($seg_type == 1) {   print "[ "; }

		while ($seg_len-- > 0) {
		    $buf = &get (2);
		    $alen -= 2;
		    $as = unpack ("S", $buf);
		    print "$as ";
		}

		if ($seg_type == 1) {   print "] "; }
	    }
	    print "\n";
	}
	elsif ($type == 3) {
	    $buf = &get (4);
	    @addr = unpack ("C4", $buf);
	    $addr = join ('.', @addr);
	    print "NEXT_HOP: $addr\n";
	}
	elsif ($type == 4) {
	    $buf = &get (4); 
	    $val = unpack ("N", $buf);
	    print "MULTI_EXIT_DISC: $val\n";
	}
	elsif ($type == 6) {
	    print "ATOMIC_AGGREGATE\n";
	}
	elsif ($type == 7) {
	    $buf = &get (2); 
	    $as = unpack ("S", $buf);
	    $buf = &get (4); 
	    @addr = unpack ("C4", $buf);
	    $addr = join ('.', @addr);
	    print "AGGREGATOR: $as $addr\n";
	}
	else {
	    print "unknown attribute $type\n";
	    exit;
	}
    }

    #print "read $read size $size\n";

    if ($read < $size) {
	print "ANNOUNCE:\n";
    }
    while ($read < $size) {
	$buf = &get (1);
	$length = unpack ("C", $buf);
	#print "length = $length $read\n";exit;

	$bytes = &bytes ($length);
	$buf = &get ($bytes);
	@addr = unpack ("C$bytes", $buf);
	$addr = join ('.', @addr);
	print "  $addr/$length\n";
    }
}




sub print_mrt_header {
    local ($time, $length, $src, $dst) = @_;
    $type = 5;    #BGP
    $subtype = 1; #update

    @src = split (/\./, $src);
    @dst = split (/\./, $dst);
    if ($DEBUG) {
	print OUT pack ("NnnN", $time, $type, $subtype, $length);
	print OUT pack ('SC4', 0, @src);
	print OUT pack ('SC4', 0, @dst);
    }

    print TCP pack ("NnnN", $time, $type, $subtype, $length);
    print TCP pack ('SC4', 0, @src);
    print TCP pack ('SC4', 0, @dst);

}
    

# someday I will learn how to do integer division in perl... (sigh)
sub bytes {
    local ($length) = @_;

    if ($length <= 8) { return (1);}
    if ($length <= 16) {return (2);}
    if ($length <= 24) {return (3);}
    
    return (4);
}




sub get {
    local ($bytes) = @_;
    
    $buf = "";
    if (($n = read (INPUT, $buf, $bytes)) != $bytes) {
	if (($n == 0) && ($bytes == 12)) {exit;}
	print "read $n bytes, expected $bytes\n";
	exit;
    }
    
    $read += $bytes;
    return ($buf);
}


sub error {
    print "Usage: route_btoa.pl -i binary_data_file\n";
    exit;
}
