/*
 * $Id: attr_memory.c,v 1.1.1.1 1996/04/09 15:50:27 labovit Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <array.h>
#include <hash.h>
#include <mrt.h>
#include <lbgp.h>
#include <io.h>
#include <trace.h>

LINKED_LIST *LL_ATTR_MEMORY;


int num_attr_memory_blocks ()
{

   return (LL_GetCount (LL_ATTR_MEMORY));

}

_attr_memory_compare (bgp_attr_t *a, bgp_attr_t *b) {
   return (a->home_AS - b->home_AS);
}

init_attr_memory ()
{
   LL_ATTR_MEMORY = LL_Create (LL_AutoSort, True, 
			       LL_CompareFunction, _attr_memory_compare,
			       NULL);
}


/* this REALLY, REALLY needs to hash on aspath ! */
bgp_attr_t *lbgp_get_attr (bgp_attr_t **p_attr)
{
   bgp_attr_t *tmp_attr;

   if (*p_attr == NULL)
      return (NULL);

   ASSERT ((*p_attr)->ll_as_seg != NULL);

   /*lbgp_print_attr (*p_attr);*/

   LL_ContIterate (LL_ATTR_MEMORY, tmp_attr) {
      /* since list is sorted by home_AS, break if we are past range */
      if ((*p_attr)->home_AS < tmp_attr->home_AS)
	 break;

      if (lbgp_compare_attr (*p_attr, tmp_attr) == 1) {
	 lbgp_delete_attr (*p_attr);
	 *p_attr = NULL;
	 return (tmp_attr);
      }
   }

   /* Create new attribute record */
   LL_Add (LL_ATTR_MEMORY, *p_attr);
   return (*p_attr);
}


int rm_delete_attr (bgp_attr_t *p_attr) {

   LL_Remove (LL_ATTR_MEMORY, p_attr);

}
