/*
 * $Id: util.c,v 1.5 1996/12/23 14:37:24 masaki Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <mrt.h>
      


/* r_inet_ntoa
 * A thread safe (and IPNG) version of inet_ntoa
 * takes allocated buffer and buffer size
 */
char *r_inet_ntoa (char *buf, int n, u_char *l, int len)
{
  memset (buf, 0, n);

  /*ASSERT ( (len >= 0) && (len < 255));*/

   if (len > 24)
      sprintf(buf, "%d.%d.%d.%d/%d", l[0], l[1], l[2], l[3], len);
   else if (len > 16)
      sprintf(buf, "%d.%d.%d/%d", l[0], l[1], l[2], len);
   else if (len > 8)
      sprintf(buf, "%d.%d/%d", l[0], l[1], len);
   else 
      sprintf(buf, "%d/%d", l[0], len);

   return (buf);
}

/* r_inet_ntoa
 * A thread safe (and IPNG) version of inet_ntoa
 * takes allocated buffer and buffer size
 */
char *rinet_ntoa (char *buf, int n, prefix_t *prefix)
{
  int len = prefix->bitlen;
  u_char *l = (u_char *) prefix_tochar (prefix);
  memset (buf, 0, n);

  /*ASSERT ( (len >= 0) && (len < 255));*/

   if (len > 24)
      sprintf(buf, "%d.%d.%d.%d/%d", l[0], l[1], l[2], l[3], len);
   else if (len > 16)
      sprintf(buf, "%d.%d.%d/%d", l[0], l[1], l[2], len);
   else if (len > 8)
      sprintf(buf, "%d.%d/%d", l[0], l[1], len);
   else 
      sprintf(buf, "%d/%d", l[0], len);

   return (buf);
}

char *my_inet_ntoa_simple (u_char *l, int len)
{
   static char tmp[100];
   memset (tmp, 0, 100);

   /*   ASSERT ( (len >= 0) && (len < 255));*/

   if (len > 24)
      sprintf(tmp, "%d.%d.%d.%d", l[0], l[1], l[2], l[3]);
   else if (len > 16)
      sprintf(tmp, "%d.%d.%d", l[0], l[1], l[2]);
   else if (len > 8)
      sprintf(tmp, "%d.%d", l[0], l[1]);
   else 
      sprintf(tmp, "%d", l[0]);

   return (tmp);
}

   
/*-----------------------------------------------------------
 *  Name: 	get_netname
 *  Created:	Mon Oct 31 21:59:47 1994
 *  Author: 	Craig Labovitz   <labovit@scanf.merit.edu>
 *  DESCR:  	Given an IP prefix and bitlength, execute a whoi shell to query
 *		RRDB database and get netname
 */

char *get_netname (int dest, int bitlen)
{

   static char netname[100];
   char buf[MAXLINE];
   char tmp[100];
   char *t;
   FILE *fd;

   sprintf(tmp, "whois -h prdb.merit.edu %s/%d",
	   r_inet_ntoa (tmp, MAXLINE, (char *) &(dest),bitlen), bitlen);

   if ( (fd = popen (tmp, "r")) == NULL)
      return ("UNKNOWN");

   while (fgets (tmp, 100, fd) != NULL) {
      if ( (t = (char *) strstr (tmp, "netname:")) != NULL) {
	 strcpy (netname, t+12);
	 fclose (fd);
	 netname[strlen(netname) -1] = '\0';
	 return (netname);
      }
   }

   fclose (fd);
   return ("UNKNOWN");
}





/*-----------------------------------------------------------
 *  Name: 	munge_route_string
 *  Created:	Sun Oct 16 23:05:23 1994
 *  Author: 	Craig Labovitz   <labovit@scanf.merit.edu>
 *  DESCR:  	parse xx.xx/xx argument into dest/bitlength
 */

int munge_prefix_string (char *arg, int *bitlen, u_char *dest)
{
   
   int num = 0;
   char *c, *str;
   int digit = 0;
   str = strdup (arg);
   
   /* get bit length */
   if ( (c = (char *) strchr (str, '/')) != NULL) {

      *c++ = '\0';
      if (! my_atoi (c, &num))
	 return (-1);
      *bitlen = (u_char) num;
   }
   else
      *bitlen = 32;
   
   while (( (c = (char *) strchr (str, '.')) != NULL) && (digit < 3)) {
      *c = '\0';
      if (! my_atoi(str, &num))
	 return (-1);
      dest[digit++] = (u_char) num;
      str = ++c;
   }

    if (! my_atoi(str, &num))
       return (-1);

    dest[digit] = (u_char) num;
    return (1);
}


/*-----------------------------------------------------------
 *  Name: 	my_atoi
 *  Created:	Wed Oct 26 00:04:36 1994
 *  Author: 	Laurent Joncheray <lpj@merit.edu>
 *  DESCR:  	
 */

int my_atoi(str, i)
        char *str;
        int *i;
{
        for(*i = 0; *str; str++) {
                if (!isdigit(*str))
                        return(0);
                *i = *i * 10 + ((int)*str - 0x30);
        }
	if ( (*i < 0) || (*i > 255))
	   return (0);
        return(1);
}



/*-----------------------------------------------------------
 *  Name: 	atox
 *  Created:	Tue Nov 26 20:32:23 EST 1996
 *  Author: 	Masaki Hirabaru <masaki@merit.edu>
 *  DESCR:  	Hex string into binary
 */

int atox(str)
        char *str;
{
	int x = 0;

        for(; *str; str++) {
		int c = toupper (*str);

                if (isdigit(c)) {
			x = x * 16 + c - '0';
		}
		else if (c >= 'A' && c <= 'F') {
			x = x * 16 + c - 'A' + 10;
		}
		else {
                        return(x);
		}
        }
        return(x);
}



  
/*-----------------------------------------------------------
 *  Name: 	my_strftime
 *  Created:	Mon Dec 19 14:15:42 1994
 *  Author: 	Craig Labovitz   <labovit@snoopy.merit.net>
 *  DESCR:  	Given a time long and format, return string. 
 *		If time <=0, use current time of day
 */

char *my_strftime(long in_time, char *fmt)
{
  char *tmp = malloc (MAXLINE);
   long t;
   struct tm *tm;

   if (in_time <= 0)
      t = time (NULL);
   else
      t = in_time;

   tm = localtime(&t);

   strftime (tmp, MAXLINE, fmt, tm);
   return (tmp);
}



buffer_t *New_Buffer (int len) {
   buffer_t *tmp = New (buffer_t);

   tmp->data = NewArray (u_char, len);
   tmp->len = len;

   return (tmp);

}
