/*
 * $Id: solaris.c,v 1.2 1996/12/23 18:49:36 masaki Exp $
 */

#include <config.h>
#include <stdio.h>
#include <version.h>
#include <sys/ioctl.h>
#include <sys/sockio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <syslog.h>
#include <string.h>
#include <New.h>
#include <linked_list.h>
#include <interface.h>


#define MAX_INTERFACES 32	/* Yeah right. */
extern interface_master_t *INTERFACE_MASTER;

interface_t *ifstatus (char *name);

int read_interfaces () {
  struct ifconf ifc;
#ifdef HAVE_IPV6
  struct v6conf ifreq, *ifptr, *end;
#else
  struct ifreq ifreq, *ifptr, *end;
#endif /* HAVE_IPV6 */
  int s, n, bufsize;
  char *name;
  interface_t *interface;

  char buffer[MAX_INTERFACES * sizeof(struct ifreq)];

#ifdef HAVE_IPV6
  if ((s = socket (AF_INET6, SOCK_DGRAM, 0)) < 0) {
#else
  if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
#endif /* HAVE_IPV6 */
    trace (FATAL, INTERFACE_MASTER->trace, 
	     "socket: %s\n", strerror (errno));
    return (-1);
  }

  ifc.ifc_len = sizeof (buffer);
  ifc.ifc_buf = buffer;

#ifdef HAVE_IPV6
  if (ioctl(s, SIOCGIFV6CONF, (char *)&ifc) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFV6CONF (%s)\n", strerror (errno));
    return (-1);
  }
#else /* ! HAVE_IPV6 */
  if (ioctl(s, SIOCGIFCONF, (char *)&ifc) < 0) {
    close(s);
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFCONF (%s)\n", strerror (errno));
    return (-1);
  }
#endif /* HAVE_IPV6 */
  close (s);

#ifdef HAVE_IPV6
  end = (struct v6conf *) (ifc.ifc_buf + ifc.ifc_len);
  ifptr = (struct v6conf *) ifc.ifc_req;
#else
  end = (struct ifreq *) (ifc.ifc_buf + ifc.ifc_len);
  ifptr = ifc.ifc_req;
#endif /* HAVE_IPV6 */

  while (ifptr < end) {
#ifdef HAVE_IPV6
    name = ifptr->v6cf_name;
#else
    name = ifptr->ifr_name;
#endif /* HAVE_IPV6 */
    interface = ifstatus (name);
    if (interface == NULL) continue;
    ifstatus_v4 (interface, name);
#ifdef HAVE_IPV6
    ifstatus_v6 (interface, name);
#endif /* HAVE_IPV6 */

    ifptr++;
  }
}


/* get interface configuration */
interface_t *ifstatus (char *name) {
  struct ifreq ifr;
  int s;
  u_long flags, mtu;
  char tmp[MAXLINE];
  char *cp;
  interface_t *interface;

  strncpy (ifr.ifr_name, name, sizeof (ifr.ifr_name));

/*  if (cp = strrchr (ifr.ifr_name, ':'))
    *cp = '\0'; /* Remove the :n extension from the name */

  if (cp = strrchr (ifr.ifr_name, '#'))
    *cp = '\0'; /* Remove the # extension from the name */

  if (interface = find_interface_byname (ifr.ifr_name))
    return (interface);

  if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
    trace (FATAL, INTERFACE_MASTER->trace, 
	     "socket: %s\n", strerror (errno));
    /* NOTREACHED */
  }

  if (ioctl(s, SIOCGIFFLAGS, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
	"SIOCGIFFLAGS for % (%s)\n", name, strerror (errno));
    close(s);
    return (NULL);
  }
  assert (sizeof (ifr.ifr_flags) == 2); 
  flags = ifr.ifr_flags&0x0000ffff; /* short */

  if (ioctl(s, SIOCGIFMTU, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
	"SIOCSIFMTU for % (%s)\n", name, strerror (errno));
    close(s);
    return (NULL);
  }
#define ifr_mtu ifr_metric
  mtu = ifr.ifr_mtu;

  interface = new_interface (name, flags, mtu, 0);
  close(s);
  return (interface);
}


/* get interface configuration for IPv4 */
int ifstatus_v4 (interface_t *interface, char *name) {
  struct ifreq ifr;
  struct sockaddr_in addr, mask, dest;
  int s;
  u_long flags;
  char *cp;

  if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
    trace (FATAL, INTERFACE_MASTER->trace, 
	     "socket: %s\n", strerror (errno));
    /* NOTREACHED */
  }

  memcpy (ifr.ifr_name, name, sizeof (ifr.ifr_name));
  flags = interface->flags;

  if (ioctl(s, SIOCGIFADDR, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
	"SIOCGIFADDR for % (%s)\n", name, strerror (errno));
    close (s);
    return (-1);
  }
  memcpy (&addr, &ifr.ifr_addr, sizeof (addr));

  if (addr.sin_family != AF_INET || addr.sin_addr.s_addr == INADDR_ANY) {
#if 0
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFADDR returns strange address (family=%d)\n", addr.sin_family);
#endif
    close (s);
    return (1);
  }

  if (ioctl(s, SIOCGIFNETMASK, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFNETMASK for % (%s)\n", name, strerror (errno));
    /* sometimes, no netmask */
    memset (&ifr.ifr_addr, -1, sizeof (ifr.ifr_addr));
  }
  memcpy (&mask, &ifr.ifr_addr, sizeof (mask));

  if (BIT_TEST (flags, IFF_POINTOPOINT)) {
    if (ioctl(s, SIOCGIFDSTADDR, (caddr_t)&ifr) < 0) {
      trace (ERROR, INTERFACE_MASTER->trace, 
        "SIOCGIFDSTADDR for % (%s)\n", name, strerror (errno));
      /* sometimes, no destination address */
      memset (&ifr.ifr_addr, 0, sizeof (ifr.ifr_addr));
    }
  }
  else if (BIT_TEST (flags, IFF_BROADCAST)) {
    if (ioctl(s, SIOCGIFBRDADDR, (caddr_t)&ifr) < 0) {
      trace (ERROR, INTERFACE_MASTER->trace, 
        "SIOCGIFBRDADDR for % (%s)\n", name, strerror (errno));
      /* sometimes, no broadcast address ??? */
      memset (&ifr.ifr_addr, 0, sizeof (ifr.ifr_addr));
    }
  }
  memcpy (&dest, &ifr.ifr_addr, sizeof (dest));

  if (cp = strchr (ifr.ifr_name, ':'))
    *cp = '\0'; /* Remove the :n extension from the name */

  add_addr_to_interface (interface, AF_INET, 
      (char *)&addr.sin_addr.s_addr,
       mask2len ((char *)&mask.sin_addr.s_addr, 4),
      (char *)&dest.sin_addr.s_addr);
  close (s);
  return (1);
}


#ifdef HAVE_IPV6 
/* get interface configuration for IPv6 */
int ifstatus_v6 (interface_t *interface, char *name) {
  struct ifreq ifr;
  struct in6_addr addr, sin_zero;
  struct in6_addr sin, *dest = NULL;
  struct v6addrreq v6addrreq;
  struct v6maskreq v6maskreq;
  u_long flags, mask;
  int s;
  char *cp;

  if ((s = socket(AF_INET6, SOCK_DGRAM, 0)) < 0) {
    trace (FATAL, INTERFACE_MASTER->trace, 
	     "socket: %s\n", strerror (errno));
    close(s);
    return (-1);
  }

  memcpy (ifr.ifr_name, name, sizeof (ifr.ifr_name));

  flags = interface->flags;

  memcpy (v6addrreq.v6ar_name, name, sizeof (v6addrreq.v6ar_name));

  if (ioctl(s, SIOCGIFV6ADDR, (caddr_t)&v6addrreq) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFV6ADDR for % (%s)\n", name, strerror (errno));
    close (s);
    return (-1);
  }
  memcpy (&addr, &v6addrreq.v6ar_addr, sizeof (addr));
  
  /* not really an IPv6 address/interface */
  memset (&sin_zero, 0, sizeof (sin_zero));
  if (!memcmp (&addr, &sin_zero, sizeof (sin_zero))) {
#if 0
    trace (ERROR, INTERFACE_MASTER->trace, 
      "Interface %s doesn't have IPv6 address\n", name);
#endif
    return (0);
  }

  memcpy (v6maskreq.v6mr_name, name, sizeof (v6maskreq.v6mr_name));
  if (ioctl(s,  SIOCGIFV6MASK, (caddr_t)&v6maskreq) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFV6MASK for % (%s)\n", name, strerror (errno));
    close (s);
    return (-1);
  }
  mask = v6maskreq.v6mr_mask;

  if (BIT_TEST (flags, IFF_POINTOPOINT)) {
    if (ioctl(s, SIOCGIFV6DST, (caddr_t)&v6addrreq) >= 0) {
      dest = &sin;
      memcpy (dest, &v6addrreq.v6ar_addr, sizeof (*dest));
    }
    else {
      trace (ERROR, INTERFACE_MASTER->trace, 
        "No destination? for %s\n", name);
    }
  }

  if (cp = strchr (v6addrreq.v6ar_name, ':'))
    *cp = '\0'; /* Remove the :n extension from the name */

  add_addr_to_interface (interface, AF_INET6, 
       (char *)&addr, mask, (char *)dest);
  close (s);
  return (1);
}

#endif HAVE_IPV6 

/*
 * $Id: solaris.c,v 1.2 1996/12/23 18:49:36 masaki Exp $
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <mrt.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <trace.h>
#include <signal.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <sys/sockio.h>
#include <netinet/in.h>
#include <sys/tihdr.h>
#include <sys/tiuser.h>
#include <sys/stat.h>
#include <inet/common.h>
#include <fcntl.h>
#include <stropts.h>
#include <net/if.h>
#include <inet/mib2.h>
#include <inet/ip.h>
#include <rib.h>
#include <interface.h>


/* kernel_update_route
 * 0 = add, 1 = change, 2 = delete
 */
int kernel_update_route (int cmd, prefix_t *dest, prefix_t *next_hop, int index)
{
  int s;
  struct rtentry rt;
  struct sockaddr_in *dst = (struct sockaddr_in *)&rt.rt_dst;
  struct sockaddr_in *gateway = (struct sockaddr_in *)&rt.rt_gateway;
#ifdef HAVE_IPV6
  struct v6rtreq rt6;
#endif /* HAVE_IPV6 */
  struct ifnet inf;
  interface_t *interface;
  int op;

  if (dest->family == AF_INET) {

    if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
      trace (FATAL, MRT->trace, "kernel socket (%s)\n", strerror (errno));
      return (-1);
    }

    memset (&rt, 0, sizeof (rt));

    dst->sin_family = AF_INET;
    memcpy (&dst->sin_addr, prefix_tochar (dest), sizeof (dst->sin_addr));

    gateway->sin_family = AF_INET;
    memcpy (&gateway->sin_addr, prefix_tochar (next_hop), 
        sizeof (gateway->sin_addr));

    if (dest->bitlen == 32)
      rt.rt_flags  |= RTF_HOST;

    rt.rt_flags  |= RTF_UP;
    if (gateway->sin_addr.s_addr != INADDR_ANY) {
      rt.rt_flags |= RTF_GATEWAY;
    }
#ifdef notdef
    if (cmd == KERNEL_UPDATE_ADD) {
      /* I'm not sure this does work -- masaki */
      interface = find_interface_byindex (index);
      inf.if_name = interface->name;
      rt.rt_ifp =  &inf;
    }
#endif

    switch (cmd) {
      case KERNEL_UPDATE_ADD:
        op = SIOCADDRT;
        break;
      case KERNEL_UPDATE_DEL:
        op = SIOCDELRT;
        break;
      default:
        assert (0);
        break;
    }
    if (ioctl (s, op, &rt) < 0) {
      trace(ERROR, MRT->trace, "kernel ioctl (%s)\n", strerror (errno));
      close (s);
      return (-1);
    }
  
  }
#ifdef HAVE_IPV6
  else if (dest->family == AF_INET6) {

    if ((s = socket (AF_INET6, SOCK_DGRAM, 0)) < 0) {
      trace (FATAL, MRT->trace, "kernel socket (%s)\n", strerror (errno));
      return (-1);
    }

    memset (&rt6, 0, sizeof (rt6));

    memcpy (&rt6.v6rt_dst, prefix_tochar (dest), sizeof (rt6.v6rt_dst));
    memcpy (&rt6.v6rt_gw, prefix_tochar (next_hop), sizeof (rt6.v6rt_gw));
    rt6.v6rt_mask = dest->bitlen;

    if (dest->bitlen == 128)
      rt6.v6rt_flags  |= RTF_HOST;

    rt6.v6rt_flags  |= RTF_UP;
    if (!ipv6_any_addr (&rt6.v6rt_gw)) {
      rt6.v6rt_flags  |= RTF_GATEWAY;
    }

    if (cmd == KERNEL_UPDATE_ADD) {
      /* I'm not sure this does work -- masaki */
      interface = find_interface_byindex (index);
      assert (interface);
      strncpy (rt6.v6rt_ifname, interface->name, sizeof (rt6.v6rt_ifname));
      /* XXX dirty way! */
      if (strchr (rt6.v6rt_ifname, '#') == NULL) {
        strcat (rt6.v6rt_ifname, "#v6");
      }
    }

    switch (cmd) {
      case KERNEL_UPDATE_ADD:
        op = SIOCADDV6RT;
        break;
      case KERNEL_UPDATE_DEL:
        op = SIOCDELV6RT;
        break;
      default:
        assert (0);
        break;
    }
    if (ioctl (s, op, &rt6) < 0) {
      trace(ERROR, MRT->trace, "kernel ioctl (%s)\n", strerror (errno));
      close (s);
      return (-1);
    }
  }
#endif /* HAVE_IPV6 */
  else {
    assert (0); /* not a family we know about */
  }

  close (s);
  return (1);
}


int kernel_read_rt_table (void (*add_kernel_route)())
{
  kernel_read_rt_table_v4 (add_kernel_route);
#ifdef HAVE_IPV6
  kernel_read_rt_table_v6 (add_kernel_route);
#endif /* HAVE_IPV6 */
}


int kernel_read_rt_table_v4 (void (*add_kernel_route)())
{
  int sd, flags;
  struct strbuf strbuf;
  struct T_optmgmt_req *tor;
  struct T_optmgmt_ack *toa;
  struct T_error_ack *tea;
  struct opthdr *req;
  int rc = -1;

  if ((sd = open("/dev/ip", O_RDWR)) < 0)
    return (-1);

  strbuf.maxlen = getpagesize ();
  strbuf.buf = (char *) malloc (strbuf.maxlen);
  if (strbuf.buf == NULL) {
    goto finish;
  }
  tor = (struct T_optmgmt_req *) strbuf.buf;
  toa = (struct T_optmgmt_ack *) strbuf.buf;
  tea = (struct T_error_ack *) strbuf.buf;

  tor->PRIM_type = T_OPTMGMT_REQ;
  tor->OPT_offset = sizeof(struct T_optmgmt_req);
  tor->OPT_length = sizeof(struct opthdr);
  tor->MGMT_flags = MI_T_CURRENT;

  req = (struct opthdr *) (tor + 1);
  req->level = MIB2_IP;		
  req->name = 0;
  req->len = 0;

  strbuf.len = tor->OPT_length + tor->OPT_offset;
  flags = 0;
  rc = putmsg(sd, &strbuf, (struct strbuf *) 0, flags);
  if (rc < 0)
    goto finish;

  req = (struct opthdr *) (toa + 1);

  for (;;) {
    flags = 0;
    rc = getmsg(sd, &strbuf, (struct strbuf *) 0, &flags);
    if (rc < 0)
      goto finish;                /* this is EOD msg */
    if (rc == 0
            && strbuf.len >= sizeof(struct T_optmgmt_ack)
            && toa->PRIM_type == T_OPTMGMT_ACK
            && toa->MGMT_flags == T_SUCCESS
            && req->len == 0) {
      rc = 1;
      goto finish;                /* this is EOD msg */
    }
    if (strbuf.len >= sizeof(struct T_error_ack)
            && tea->PRIM_type == T_ERROR_ACK) {
      rc = -1;
      goto finish;
    }
    if (rc != MOREDATA
            || strbuf.len < sizeof(struct T_optmgmt_ack)
            || toa->PRIM_type != T_OPTMGMT_ACK
            || toa->MGMT_flags != T_SUCCESS) {
      rc = -1;
      goto finish;
    }
    if (req->level != MIB2_IP || req->name != MIB2_IP_21) {
      do {
        rc = getmsg(sd, (struct strbuf *) 0, &strbuf, &flags);
      } while (rc == MOREDATA);
      continue;
    }
    strbuf.maxlen = (getpagesize () / sizeof (mib2_ipRouteEntry_t)) * 
                                      sizeof (mib2_ipRouteEntry_t);
    strbuf.len = 0;
    flags = 0;
    do {
      rc = getmsg(sd, (struct strbuf * ) 0, &strbuf, &flags);
      if (rc < 0)
        goto finish;
      if (rc == 0 || rc == MOREDATA) {
        mib2_ipRouteEntry_t *rp = (mib2_ipRouteEntry_t *)strbuf.buf;
        mib2_ipRouteEntry_t *lp = 
            (mib2_ipRouteEntry_t *)(strbuf.buf+strbuf.len);
        do {
          if (BIT_TEST (rp->ipRouteInfo.re_ire_type, IRE_BROADCAST))
            continue;
          if (BIT_TEST (rp->ipRouteInfo.re_ire_type, IRE_ROUTE_REDIRECT))
            continue;
	  /* Currently MRT doesn't handle direct connected routes */
          if (!BIT_TEST (rp->ipRouteInfo.re_ire_type, IRE_GATEWAY|IRE_NET))
            continue;
          if (rp->ipRouteNextHop == INADDR_ANY)
            continue;
#if 0
printf("%s/%d ", inet_ntoa (*(struct in_addr *)&rp->ipRouteDest),
mask2len ((char *)&rp->ipRouteMask, 4));
printf("%s ", inet_ntoa (*(struct in_addr *)&rp->ipRouteNextHop));
printf("type %x ", rp->ipRouteType);
printf("ire %x\n", rp->ipRouteInfo.re_ire_type);
#endif
          add_kernel_route (AF_INET, &rp->ipRouteDest, &rp->ipRouteNextHop,
              mask2len ((char *)&rp->ipRouteMask, 4));
        } while (++rp < lp);
      }
    } while (rc == MOREDATA);
  }
  rc = 1;
finish:
  close (sd);
  return (rc);
}


#ifdef HAVE_IPV6
int kernel_read_rt_table_v6 (void (*add_kernel_route)())
{
  int sd, flags;
  struct strbuf strbuf;
  struct T_optmgmt_req *tor;
  struct T_optmgmt_ack *toa;
  struct T_error_ack *tea;
  struct opthdr *req;
  struct in6_addr zero6 = IPV6ADDR_ANY_INIT;
  int rc = -1;

  if ((sd = open("/dev/ip", O_RDWR)) < 0)
    return (-1);

  strbuf.maxlen = getpagesize ();
  strbuf.buf = (char *) malloc (strbuf.maxlen);
  if (strbuf.buf == NULL) {
    goto finish;
  }
  tor = (struct T_optmgmt_req *) strbuf.buf;
  toa = (struct T_optmgmt_ack *) strbuf.buf;
  tea = (struct T_error_ack *) strbuf.buf;

  tor->PRIM_type = T_OPTMGMT_REQ;
  tor->OPT_offset = sizeof(struct T_optmgmt_req);
  tor->OPT_length = sizeof(struct opthdr);
  tor->MGMT_flags = MI_T_CURRENT;

  req = (struct opthdr *) (tor + 1);
  req->level = MIB2_IP6;
  req->name = 0;
  req->len = 0;

  strbuf.len = tor->OPT_length + tor->OPT_offset;
  flags = 0;
  rc = putmsg(sd, &strbuf, (struct strbuf *) 0, flags);
  if (rc < 0)
    goto finish;

  req = (struct opthdr *) (toa + 1);

  for (;;) {
    flags = 0;
    rc = getmsg(sd, &strbuf, (struct strbuf *) 0, &flags);
    if (rc < 0)
      goto finish;                /* this is EOD msg */
    if (rc == 0
            && strbuf.len >= sizeof(struct T_optmgmt_ack)
            && toa->PRIM_type == T_OPTMGMT_ACK
            && toa->MGMT_flags == T_SUCCESS
            && req->len == 0) {
      rc = 1;
      goto finish;                /* this is EOD msg */
    }
    if (strbuf.len >= sizeof(struct T_error_ack)
            && tea->PRIM_type == T_ERROR_ACK) {
      rc = -1;
      goto finish;
    }
    if (rc != MOREDATA
            || strbuf.len < sizeof(struct T_optmgmt_ack)
            || toa->PRIM_type != T_OPTMGMT_ACK
            || toa->MGMT_flags != T_SUCCESS) {
      rc = -1;
      goto finish;
    }
    if (req->level != MIB2_IP6 || req->name != MIB2_IP_23) {
      do {
        rc = getmsg(sd, (struct strbuf *) 0, &strbuf, &flags);
      } while (rc == MOREDATA);
      continue;
    }
    strbuf.maxlen = (getpagesize () / sizeof (mib2_ip6RouteEntry_t)) * 
                                      sizeof (mib2_ip6RouteEntry_t);
    strbuf.len = 0;
    flags = 0;
    do {
      rc = getmsg(sd, (struct strbuf * ) 0, &strbuf, &flags);
      if (rc < 0)
        goto finish;
      if (rc == 0 || rc == MOREDATA) {
        mib2_ip6RouteEntry_t *rp = (mib2_ip6RouteEntry_t *)strbuf.buf;
        mib2_ip6RouteEntry_t *lp = 
            (mib2_ip6RouteEntry_t *)(strbuf.buf+strbuf.len);
        do {
          if (BIT_TEST (rp->ip6RouteInfo.re_ire_type, IRE_BROADCAST))
            continue;
          if (BIT_TEST (rp->ip6RouteInfo.re_ire_type, IRE_ROUTE_REDIRECT))
            continue;
	  /* Currently MRT doesn't handle direct connected routes */
          if (!BIT_TEST (rp->ip6RouteInfo.re_ire_type, IRE_GATEWAY|IRE_NET))
            continue;
          if (memcmp (&zero6, &rp->ip6RouteNextHop, 16) == 0)
            continue;
#if 0
printf("%s/%d ", inet_ntop (AF_INET6, &rp->ip6RouteDest, NULL, 0),
mask2len ((char *)&rp->ip6RouteMask, 16));
printf("%s ", inet_ntop (AF_INET6, &rp->ip6RouteNextHop, NULL, 0));
printf("type %x ", rp->ip6RouteType);
printf("ire %x\n", rp->ip6RouteInfo.re_ire_type);
#endif
          add_kernel_route (AF_INET6, &rp->ip6RouteDest, &rp->ip6RouteNextHop,
              mask2len ((char *)&rp->ip6RouteMask, 16));
        } while (++rp < lp);
      }
    } while (rc == MOREDATA);
  }
  rc = 1;
finish:
  close (sd);
  return (rc);
}
#endif /* HAVE_IPV6 */
