/* 
 * $Id: view.h,v 1.3 1996/06/20 20:19:21 labovit Exp $
 */

#ifndef _VIEW_H
#define _VIEW_H

#include <lbgp.h>
#include <stack.h>
#include <trace.h>
#include <hash.h>
#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */
#include <lbgp.h>

#define MAX_BGP_PEERS		32

struct _bgp_route_head_t;
typedef struct _bgp_route_t {
  struct _bgp_route_head_t*	head; /* pointer back to our route_head */
  int				pref; /* pref determined bu metric/policy */
  bgp_attr_t*			attr;
  long				time;		       
} bgp_route_t;


/* state bits */
#define VRTS_DELETE	 1	/* about to be deleted -- route is withdrawn */
#define VRTS_ACTIVE	 2
#define VRTS_CHANGE	 4


/* the change bits explain what caused the change in state */
typedef struct _bgp_route_head_t {
   u_long	state_bits;	/* active, holddown, withdrawn */
  /*u_long	change_bits;	new, change, withdrawn */
   u_long	peer_mask;	/* mask of peers we sent this route to */
   prefix_t	prefix;
   bgp_route_t	*active;	/* a pointer to best, or active route_node */
   bgp_route_t	*last_active;	/* a pointer to last active route_node */
   LINKED_LIST *ll_routes;
} bgp_route_head_t;


typedef struct _view_t {
  /*int			lock; */
   pthread_mutex_t	mutex_lock;
   int			num_active_routes;
   u_long		peer_mask; /* mask of peers route annouced to */
   HASH_TABLE*		hash;
   trace_t*		trace;
   LINKED_LIST*		ll_changed_routes; /* changed routed heads */
   LINKED_LIST*		ll_withdrawn_routes; /* deleted routed heads */
  /*void *user;		 hook for program or user specific data */
  /*HASH_TABLE		peer_hash[MAX_BGP_PEERS];*/
} view_t;


typedef struct _update_bucket_t {
  LINKED_LIST *ll_prefix;
  bgp_attr_t  *attr;
} update_bucket_t;

/* public functions */
view_t*		New_View();

#endif /* _VIEW_H */
