/*
 * $Id
 */		

#ifndef _SCHEDULE_H
#define _SCHEDULE_H

#include <trace.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */


typedef struct _event_t {
   void (*call_fn)();
   int	narg;
   void *arg1;
   void *arg2;
   void *arg3;
   void *arg4;
} event_t;



typedef struct _schedule_t {

   pthread_t 		self;
   pthread_mutex_t 	mutex_lock;
   pthread_mutex_t 	mutex_cond_lock;
   pthread_cond_t	cond_new_event;

   char 	*description;		/* descrip of schedule for tracing */
   trace_t	*trace;
   int 		new_event_flag;
   LINKED_LIST	*ll_events;
} schedule_t;


typedef struct _schedule_master_t {
  LINKED_LIST *ll_schedules;
  trace_t	*trace;
} schedule_master_t;

extern schedule_master_t *SCHEDULE_MASTER;


/* public functions */
int init_schedules (trace_t *trace);
schedule_t *New_Schedule (char *description, trace_t *trace);
int schedule_event (schedule_t *schedule, void (*call_fn)(), 
		    int narg, ...);

int schedule_wait_for_event (schedule_t *schedule);
void Delete_Event (event_t *event);
int clear_schedule (schedule_t *schedule);
int process_all_schedules ();
int schedule_count (schedule_t *schedule);

#ifndef HAVE_LIBPTHREAD
pthread_t get_thread_id ();
pthread_t set_thread_id (pthread_t id);
#endif /* HAVE_LIBPTHREAD */

#endif /* _SCHEDULE_H */
