/*
 * $Id: ripng.h,v 1.12 1996/12/23 14:36:34 masaki Exp $
 */

#ifndef _RIPNG_H
#define _RIPNG_H

#include <linked_list.h>
#include <trace.h>
#include <timer.h>
#include <schedule.h>
#include <hash.h>
#include <mrt.h>
#include <proto.h> 


#define RIPNG_DEFAULT_PORT	521  /* this is correct one defined in ID */

/* #define RIPNG_MAX_PDU		512 /* use mtu instead */

#define RIPNG_REQUEST	1
#define RIPNG_RESPONSE	2

#define RIPNG_VERSION	1

#if 0 /* test */
#define RIPNG_TIMEOUT_INTERVAL	60
#define RIPNG_GARBAGE_INTERVAL	90
#define RIPNG_UPDATE_INTERVAL	15
#define RIPNG_UPDATE_JITTER 	0
#else
#define RIPNG_TIMEOUT_INTERVAL	180
#define RIPNG_GARBAGE_INTERVAL	300
#define RIPNG_UPDATE_INTERVAL	30
#define RIPNG_UPDATE_JITTER 	15
#endif

#define RIPNG_INFINITY		16

typedef struct _ripng_t {
   u_long	interface_mask;	/* mask of interfaces ripng is configed for */
   int		sockfd;		/* socket we are listeing on */
   HASH_TABLE	*hash;		/* hash of prefixes */
   trace_t	*trace;

   int		(*update_call_fn)();
   schedule_t	*schedule;
   mtimer_t	*timer;		/* one timer used for sending update */
   mtimer_t	*age;		/* aging routes */
   mtimer_t	*flash;		/* flash update */

   pthread_mutex_t send_mutex_lock;
} ripng_t;

typedef struct _ripng_attr_t {
   u_char	type;	
   prefix_t*	nexthop;
   int 		ref_count;
   gateway_t	*gateway;
   short	local;

   u_char	version;
   u_char	metric;
   u_short	tag;
   u_long	mask;
} ripng_attr_t;


typedef struct _ripng_route_t {
  u_long	flags;
  prefix_t	*prefix6;
  ripng_attr_t	*attr;
  long		time;
} ripng_route_t;


/* route flags */
#define RT_RIPNG_CHANGE	1
#define RT_RIPNG_DELETE	2

extern ripng_t *RIPNG;

/* user settable attributes */
enum RIPNG_ATTR {
   RIPNG_NULL = 0,
   RIPNG_TRACE_STRUCT,
   RIPNG_RT_UPDATE_FN,		/* function to call when ripng routes change */
   RIPNG_USE_PORTSERVER		/* use portserver library for listening */
};


/* public functions */
ripng_route_t*	New_Ripng_Route (prefix_t *prefix6, ripng_attr_t *attr);
int		Delete_Ripng_Route (ripng_route_t *route);
ripng_attr_t *New_Ripng_Attr (int metric);
ripng_attr_t *Ref_Ripng_Attr (ripng_attr_t *attr);
void Deref_Ripng_Attr (ripng_attr_t *tmp);

#endif /* _RIPNG_H */
