

/*
 * All of the following structures closely follow RIPE-181 syntax. 
 * Please see this document for more information
 *
 */

/* routing policy expression holder */
typedef struct _RPE_Holder {
   short type;
   short negated;
   union {
      char *string;
      short as;
      LINKED_LIST *ll_prefix;	/* prefix prefix list */
   } data;
} RPE_Holder;


/* holds a single as-in or as-out line */
typedef struct _AS_RPE_Holder {
   enum {AS_OUT, AS_IN} type;
   short AS;			/* from AS or to AS */
   int cost;			/* only used in as-in entries */
   short prefix_based_policy;	/* cannot  do policy soley on AS path info */
   LINKED_LIST *ll_rpe;		/* linked list of RPE_Holders */
} AS_RPE_Holder;



/* This is the "master" object that stores policy for an AS */
typedef struct _Aut_Num_Object {
   short	aut_num;		/* ripe speak for AS */
   LINKED_LIST  *ll_as_in_rpe_holder;	/* ll of as_out _AS_RPE_Holders */
   LINKED_LIST  *ll_as_out_rpe_holder;	/* ll of as_out _AS_RPE_Holders */
} Aut_Num_Object;




enum Policy_Source_Types {
   DISKFILE, 
   DATABASE
};

enum Policy_Attr {
   POLICY_NULL,
   POLICY_SOURCE = 1,
   POLICY_SOURCE_NAME,
   POLICY_AUTNUM,
};



typedef struct _Policy_Struct {
   enum Policy_Source_Types source;
   char *name;			/* database or file name */
   short aut_num;		/* RIPE181 Aut-num object number */
   /*short AS;			 Peer AS sending/receiving prefixs */
   Aut_Num_Object *aut_obj;
   LINKED_LIST *ll_policy;
   trace_t *trace;			/* pointer to trace_t */
} Policy_Struct;



/* in ripe181.c */
short *ripe181_apply_as_entry (Policy_Struct *policy,int type, short AS, 
			       bgp_attr_t *p_attr, 
			       LINKED_LIST *ll_prefixes);
int ripe181_eval_bgp (bgp_attr_t *bgp_route_attr, prefix_t *prefix, 
		      LINKED_LIST *ll_rpe);
Policy_Struct *New_Policy (trace_t *trace, int source, char *name, 
			   short aut_num);
int set_policy (Policy_Struct *tmp, int first, ...);
int load_policy (Policy_Struct *pol);
int get_policy_from_database (FILE *file, Policy_Struct *pol);


/* in ripe181_util.c */
void ripe181_prefix_list_print (LINKED_LIST *ll_pref);
void ripe181_rpe_list_print (LINKED_LIST *_ll_rpe);
void ripe181_rpe_print (RPE_Holder *tmp);
void ripe181_print_aut_num_object (Aut_Num_Object *aut_obj);
Aut_Num_Object *ripe181_get_aut_num_object (short AS, LINKED_LIST *ll_policy);
AS_RPE_Holder *ripe181_get_as_rpe_holder (short AS, 
					  LINKED_LIST *ll_as_rpe_holder);
LINKED_LIST *load_ripe181_policy (char *filename);
