/* 
 * $Id: rib.h,v 1.6 1996/12/23 14:36:32 masaki Exp $
 */

#ifndef _RIB_H
#define _RIB_H

#include <lbgp.h>
#include <stack.h>
#include <trace.h>
#include <hash.h>
#include <proto.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */

/*
 * "State" of routing table entry.
 */
#define	RTS_ACTIVE		0x0100	/* Route is active */
#define RTS_INTERIOR    	0x08	/* an interior route */
#define RTS_EXTERIOR    	0x10	/* an exterior route */
#define	RTS_HOLDDOWN		0x20	/* Route is held down */


#define	RTS_DELETE		0x40	/* Route is deleted */
#define	RTS_FREE		0x80	/* Route memory scheduled for free */


#define CONNECTED_PREF		10
#define STATIC_PREF		100
#define RIP_PREF		200
#define BGP_PREF		200
#define RIPNG_PREF		200
#define KERNEL_PREF		999999
#define HOLD_PREF		9999999 /* pref for holddown */
#define NO_PREF			9999999

#define KERNEL_UPDATE_ADD       0
#define KERNEL_UPDATE_CHG       1
#define KERNEL_UPDATE_DEL       2
#define KERNEL_UPDATE_HOLD      3
#define KERNEL_UPDATE_UNHOLD    4


struct _route_head_t;
typedef struct _route_node_t {
   struct _route_head_t *route_head;	/* pointer back to our route_head */
   int state;				/* mask of state flags */
   int pref;			/* ripe181 - as_in preference */
   int pref2;			/* internal tie-breaking pref */
   int protocol_mask;		/* bit mask of protocols using this route */
   generic_attr_t *attr;
   long time;			/* time last updated (as in RIP) */
} route_node_t;


typedef struct _route_head_t {
   prefix_t *prefix;
   route_node_t *active;	/* a pointer to best, or active route_node */
   route_node_t *last_active;	/* a pointer to best, or active route_node */
   LINKED_LIST *ll_route_nodes;
   long change_flag;
} route_head_t;


/*
 * Change is routing table entry
 */
#define	RTCF_NEXTHOP	0x01		/* Next hop change */
#define	RTCF_METRIC	0x02		/* Metric change */
#define	RTCF_METRIC2	0x04		/* Metric change */
#define	RTCF_ASPATH	0x08		/* AS path change */
#define	RTCF_TAG	0x10		/* Tag change */


typedef struct _rib_t {
   int lock;	    	/* table is LOCKED -- do not modify while set */
   pthread_mutex_t	mutex_lock;
   int num_active_routes;
   HASH_TABLE	*hash;
   trace_t	*trace;
   /*LINKED_LIST *ll_route_nodes;*/ /* delete this ?*/

   LINKED_LIST *ll_changed_route_nodes;
   void *user;		/* hook for program or user specific data */
   
} rib_t;

/* types returned by ret in rm_insert on addition to radix tree */
enum RM_RETURN_TYPES {
   RM_ROUTE_ALREADY_EXISTS,
   RM_ROUTE_LOWER_PREF,
   RM_ROUTE_BEST_PREF,
   RM_ROUTE_SAME_PREF,
   RM_NO_ACTIVE_ROUTE
};

route_node_t *New_Route_Node (route_head_t *route_head,
			      int pref, generic_attr_t *p_attr);
route_head_t *New_Route_Head (prefix_t *prefix);
rib_t *New_Route_Manager (int maxbitlen);
int rm_delete_route_node (rib_t *rm, route_node_t *route_node);

int rm_close (rib_t *route_manager);
int rm_open (rib_t *route_manager);

int init_rib (trace_t *trace);
char *proto2string (int proto);
generic_attr_t *Ref_Generic_Attr (generic_attr_t *attr);
void Deref_Generic_Attr (generic_attr_t *attr);

#endif /* _RIB_H */
