/*
 * $Id: mrt.h,v 1.17 1997/02/01 01:19:31 masaki Exp $
 */

#ifndef _MRT_H
#define _MRT_H

#include <version.h>
#include <config.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <errno.h>
#include <assert.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */

#include <New.h>
#include <linked_list.h>
#include <defs.h>
#include <object.h>
#include <trace.h>
#include <schedule.h>
#include <user.h>
#include <proto.h>
#ifdef __linux__
#include <netinet6/in6.h>
#endif

#ifdef SOLARIS
#include <thread.h>
#endif /* THREADS */

extern int IPV4;
extern int IPV6;

typedef struct _prefix_t {
   u_char 		family; /* AF_INET | AF_INET6 */
   u_int		bitlen; /* same as mask? */
   union {
     struct in_addr sin;
#ifdef HAVE_IPV6
     struct in6_addr sin6;
#endif /* IPV6 */
   } add;
   int ref_count; /* reference count */
} prefix_t;


typedef struct _Route {
   prefix_t *prefix;
   void *attr;		/* attribure strcutre like bgp_attr_t */
} Route;


enum ROUTE_ATTR_TYPES {
   ROUTE_ATTR_BGP4,
   ROUTE_ATTR_RIP,
   ROUTE_ATTR_IDRP
};


typedef struct _buffer_t {
   int len;
   u_char *data;
} buffer_t;

typedef struct _gateway_t {
  prefix_t *prefix;
  int AS;
  struct _interface_t *interface;
  char *name;
} gateway_t;

typedef struct _generic_attr_t {
   u_char		type;		/* RIP, BGP, OSPF */
   prefix_t*		nexthop;
   u_int 		ref_count;
   gateway_t		*gateway;	/* gateway we learned route from */
   u_short		local;
} generic_attr_t;

extern int VERBOSE_ERROR_FLAG; /* yuck, delete this */


/* Main MRT structure
 * holds bookkeeping information on gateways, threads, signals, etc
 * ALL MRT programs depend on this structure
 */
typedef struct _mrt_t {
  pthread_mutex_t	mutex_lock;	/* lock down structure */
  trace_t	*trace;			/* default trace - go away future? */
  LINKED_LIST	*ll_threads;		/* list of all thread_t */
  LINKED_LIST	*ll_signal_call_fn;	/* list of mrt_signal_t */
  LINKED_LIST	*ll_gateways;		/* list of gateway_t */
  LINKED_LIST   *ll_trace;		/* list of trace_t */
  char		*config_file_name;
  /* for use on non-thread systems -- current thread # */
  int		threadn;		
  u_long	protocols;		/* protocols enabled */
  u_long	rdist_static;		/* protocols redistribute static */
} mrt_t;

extern mrt_t *MRT;

/* Main thread gets all signals. Threads can request to have call_fn
 * executed upon receipt of a signal
 */
typedef struct _mrt_signal_t {
  int	signal;
  void	(*call_fn)();
} mrt_signal_t;

typedef struct _mrt_thread_t {
  char		name[100];
  pthread_t	thread;
  schedule_t	*schedule;
} mrt_thread_t;

#define ASSERT(x) {if (!x) err_dump ("\nAssert failed line %d in %s", __LINE__, __FILE__);}

#define UTIL_GET_BYTE(val, cp)   ((val) = *(cp)++)

#define UTIL_GET_SHORT(val, cp) \
        do { \
                register unsigned int Xv; \
                Xv = (*(cp)++) << 8; \
                Xv |= *(cp)++; \
                (val) = Xv; \
        } while (0)

#define UTIL_GET_LONG(val, cp) \
        do { \
                register u_long Xv; \
                Xv = (*(cp)++) << 24; \
                Xv |= (*(cp)++) << 16; \
                Xv |= (*(cp)++) << 8; \
                Xv |= *(cp)++; \
                (val) = Xv; \
        } while (0)

#define UTIL_GET_NETLONG(val, cp) \
        do { \
                register u_char *Xvp; \
                u_long Xv; \
                Xvp = (u_char *) &Xv; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                (val) = Xv; \
        } while (0)

#define UTIL_GET_BITCOUNT(bitcount, cp)  ((bitcount) = *(cp)++)

#define UTIL_PUT_BYTE(val, cp)   (*(cp)++ = (byte)(val))

#define UTIL_PUT_SHORT(val, cp) \
        do { \
                register u_short Xv; \
                Xv = (u_short)(val); \
                *(cp)++ = (byte)(Xv >> 8); \
                *(cp)++ = (byte)Xv; \
        } while (0)

#define UTIL_PUT_LONG(val, cp) \
        do { \
                register u_long Xv; \
                Xv = (u_long)(val); \
                *(cp)++ = (byte)(Xv >> 24); \
                *(cp)++ = (byte)(Xv >> 16); \
                *(cp)++ = (byte)(Xv >>  8); \
                *(cp)++ = (byte)Xv; \
        } while (0)

#define UTIL_PUT_NETLONG(val, cp) \
        do { \
                register u_char *Xvp; \
                u_long Xv = (u_long)(val); \
                Xvp = (u_char *)&Xv; \
                *(cp)++ = *Xvp++; \
                *(cp)++ = *Xvp++; \
                *(cp)++ = *Xvp++; \
                *(cp)++ = *Xvp++; \
        } while (0)


/* public functions */

prefix_t*	New_Prefix (int family, u_char *dest, int bitlen);
prefix_t*	Ref_Prefix (prefix_t *prefix);
void 		Deref_Prefix (prefix_t *prefix);
void		Delete_Prefix (prefix_t *prefix);
int		prefix_check_prefix_in_list (LINKED_LIST *ll_prefix, prefix_t *prefix);
void		print_prefix_list (LINKED_LIST *ll_prefixes);
void		print_prefix (prefix_t *p_prefix);
prefix_t*	copy_prefix (prefix_t *prefix);

#define prefix_tolong(prefix) ((prefix)->add.sin.s_addr)
#define prefix_tochar(prefix) ((u_char *)&(prefix)->add.sin)
#define prefix_toaddr(prefix) (&(prefix)->add.sin)
#ifdef HAVE_IPV6
#define prefix_toaddr6(prefix) (&(prefix)->add.sin6)
#endif /* IPV6 */

#ifdef notdef
u_char*		prefix_tochar (prefix_t *prefix);
#endif
int		prefix_compare (prefix_t *p1, prefix_t *p2);
char*		prefix_toa (prefix_t *prefix);
char*		prefix_toa2 (prefix_t *prefix, char *tmp);
prefix_t*	ascii2prefix (int family, char *string);

char*		get_netname (int dest, int bitlen);
int		munge_route_string ();
int		_atoi();
char*		my_strftime(long t, char *fmt);

int		init_gateways ();
gateway_t*	add_gateway (prefix_t *prefix, int AS, 
            /* resolve cross reference ... */ struct _interface_t *interface);
gateway_t *find_gateway (prefix_t *prefix, int AS);
char*		gateway_toa (char *tmp, gateway_t *gateway);

int		init_mrt ();
mrt_thread_t*	mrt_thread_create (char *name, schedule_t *schedule,
				   void (*call_fn)(), void *arg);

#ifdef HAVE_IPV6
int ipv6_multicast_addr (struct in6_addr *sin6);
int ipv6_link_local_addr (struct in6_addr *sin6);
int ipv6_ipv4_addr (struct in6_addr *sin6);
int ipv6_compat_addr (struct in6_addr *sin6);
int ipv6_any_addr (struct in6_addr *sin6);
u_char *netmasking (int family, u_char *addr, int bitlen);
int comp_with_mask (char *addr, char *dest, int mask);
#endif /* HAVE_IPV6 */

#if !defined(HAVE_INET_NTOP) && defined(HAVE_ADDR2ASCII)
const char *inet_ntop (int af, const void *src, char *dst, size_t size);
int inet_pton(int af, const char *src, void *dst);
#endif
#ifndef HAVE_MEMMOVE
char *memmove(char *dest, const char *src, size_t n);
#endif

#endif /* _MRT_H */
