/* 
 * $Id: route_btoa.c,v 1.7 1997/02/18 23:17:40 masaki Exp $
 */

#include <version.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <array.h>
#include <hash.h>
#include <mrt.h>
#include <lbgp.h>
#include <io.h>


void init (int argc, char *argv[]);
void print_bgp_msg (mrt_msg_t *msg);

/* globals */
int MACHINE_PARSEABLE_FLAG = 0;
char time_str[MAXLINE];

io_t *IO;
trace_t *default_trace;

int main (int argc, char *argv[])
{
   mrt_msg_t *msg;
   char *stime;

   default_trace = New_Trace ();

   IO = New_IO (default_trace);
   io_set (IO, IO_INFILE, "stdin", NULL);
   init (argc, argv);
   init_mrt (default_trace);


   while (1) {
      if ((msg = (mrt_msg_t *) io_read (IO)) == NULL) {
	/*	 printf("\nInvalid MSG ");*/
	 exit (0);
      }

      if (!MACHINE_PARSEABLE_FLAG) {
	stime = my_strftime(msg->tstamp, "%D %T");
	printf ("\n\nTIME: %s", stime);
	printf("\nTYPE: %s", S_MRT_MSG_TYPES[msg->type]);
	Delete (stime);
      }
      else
	sprintf (time_str, "%s|%u",  S_MRT_MSG_TYPES[msg->type], 
		 (u_long) msg->tstamp);

      if (msg->type == MSG_DIE) 
	 exit (0);
      
      else if (msg->type == MSG_PROTOCOL_BGP) 
	 print_bgp_msg (msg);

      else 
	 printf ("\nUnknown message type %d", msg->type);
	 
      Delete (msg);
   }
}


/* print_bgp_msg
 * 
 */
void print_bgp_msg (mrt_msg_t *msg) 
{
   gateway_t *gateway_to;
   bgp_attr_t *p_attr;
   LINKED_LIST *ll_with_prefixes, *ll_ann_prefixes;
   short *pref;

   p_attr = NULL;
   ll_with_prefixes = NULL;
   ll_ann_prefixes = NULL;
   pref = NULL;
   
   if (!MACHINE_PARSEABLE_FLAG) 
      printf("/%s", S_MRT_MGS_BGP_TYPES[msg->subtype]);
	
   if (msg->subtype == MSG_BGP_UPDATE) 
      bgp_process_update_msg (msg->value, msg->length,
			       &gateway_to,
			       &p_attr,
			       &ll_with_prefixes,
			       &ll_ann_prefixes);

   if (MACHINE_PARSEABLE_FLAG) {
      prefix_t *prefix;
      char *attr_string;

      if (ll_ann_prefixes) {
	 attr_string = (char *) bgp_attr_toa (p_attr);
	 LL_Iterate (ll_ann_prefixes, prefix) {
	    printf ("%s|A|%s|%s\n",
		    time_str, (char *) prefix_toa (prefix), attr_string);
	 
	 }
	 LL_Destroy (ll_ann_prefixes);
      }
      if (ll_with_prefixes) {
	char tmp[100];
	 LL_Iterate (ll_with_prefixes, prefix) {
	   sprintf (tmp, "%s", prefix_toa(p_attr->gateway->prefix));
	    printf ("%s|W|%s|%s\n",
		    time_str, (char *) prefix_toa (prefix),tmp);
	 }
	 LL_Destroy (ll_with_prefixes);
      }
      return;
   }

   if (ll_ann_prefixes) {
      printf ("\nTO: AS%d   %s", gateway_to->AS,
	      (char *) prefix_toa ( gateway_to->prefix));
      bgp_print_attr (p_attr);
      printf ("\nANNOUNCE:");
      if (msg->subtype == MSG_BGP_PREF_UPDATE)
	 print_pref_prefix_list (ll_ann_prefixes, pref);
      else
	 print_prefix_list (ll_ann_prefixes);
      LL_Destroy (ll_ann_prefixes);
      bgp_delete_attr (p_attr);
   }
   if (ll_with_prefixes) {
      printf ("\nTO: AS%d   %s", gateway_to->AS,
	      (char *) prefix_toa (gateway_to->prefix));
      printf ("\nWITHDRAW");
      print_prefix_list (ll_with_prefixes);
      LL_Destroy (ll_with_prefixes);
   }
}


/* init
 */
void init (int argc, char *argv[])
{
   char c;
   extern char *optarg;	/* getopt stuff */
   extern int optind;	/* getopt stuff */
   char *usage ="Usage: route_btoa [-m] [(-i|-r) input_binary_file] \n";
   int errs;
   

   while ((c = getopt(argc, argv, "i:f:o:mv")) != -1)
      switch (c) {
      /* machine parseable format */
      case 'm':
	 MACHINE_PARSEABLE_FLAG =1;
	 break;
      case 'i':	
      case 'f':	
	if (io_set (IO, IO_INFILE, (char *) optarg, NULL) < 0) {
	  printf ("Failed to open infile %s",(char *) optarg);
	  exit (0);
	}
	break;
      case 'r':
	if (io_set(IO, IO_INMSGQ, (char *) (optarg), NULL) < 0) {
          printf ("\nError setting infile %s\n", optarg);
          errs++;
        }
	break;
      case 'v':
        set_trace (default_trace, TRACE_FLAGS, TR_ALL, 
                  TRACE_LOGFILE, "stdout", NULL);
	break;
      default:
	 fprintf(stderr, usage);
	 printf ("\nMRT version (%s) compiled on %s\n\n",
		 MRT_VERSION, __DATE__);
	 exit (0);
      }



}
