#!/usr/local/bin/perl
#
# Send RSd fastdump to compute.merit.edu
#

$usage = "sendtable.pl [-h host] [-d]
        -h Host: send fastdump to host. Default = compute.merit.edu
";

$GDC = "/usr/etc/gdc";
$DUMPFILE = "rsd_dump";
$HOST = "compute.merit.edu";
$MAIL = "/usr/ucb/mail";
$SYSADM = "sysadmin";
$FTP = "/usr/local/bin/ftp compute.merit.edu";
$COMPRESS = "/usr/ucb/compress -f";
$date = `date \'+%y%m%d\'`; chop ($date);

while( $_ = $ARGV[ 0 ], /^-/ ) {
        shift;
        /^-h/ && do { $loghost = $ARGV[ 0 ] ; shift ; next; };
        /^-d/ && do { $DEBUG = 1; shift ; next; };
        /^-/  && do { die "$usage"; };
}


$err = system ("$GDC rmdump");
if ($err /256 ) {print "$GDC failed: $err\n";} 
if ($DEBUG == 1) {print "system $GDC rmdump\n";}
sleep (10);

# dump new table
$err = system ("$GDC fastdump");
if ($err /256 ) {print "$GDC failed: $err\n"; exit;} 
if ($DEBUG == 1) {print "system $GDC fastdump\n";}

# sleep and wait for dump to finish
if ($DEBUG == 1) {print "sleep\n";}
sleep (90);

# change directory to the /tmp
if ($DEBUG == 1) {print "chdir /tmp\n";}
chdir "/tmp" || die "chdir /tmp failed: $!\n";

# create temp file
if ($DEBUG == 1) {print "cp $DUMPFILE $DUMPFILE.$date\n";}
$err = system ("cp $DUMPFILE $DUMPFILE.$date") ;
if ($err / 256) {
  print "system cp $DUMPFILE $DUMPFILE.$date: $err\n";
  exit;
}

# compress file
if ($DEBUG == 1) {print "$COMPRESS $DUMPFILE.$date\n";}
$err = system ("$COMPRESS $DUMPFILE.$date");
if ($err /256 ) {
  print "system $COMPRESS $DUMPFILE.$date: $err\n";
  exit;
}        


#
# FTP the file to $loghost
#
if ($DEBUG == 1) {print "$FTP\n";}
$err = system ("$FTP");
print "$FTP failed: transfer of $DUMPFILE.$date.Z failed\n" if ($err /256 );

#
# Delete the file
#
if ($DEBUG ==1) {print "rm $DUMPFILE.*\n"}
$err = system ("/bin/rm $DUMPFILE.*");
exit(0);


