#!/usr/local/bin/perl

$DATAPATH	= "/var/spool/route_servers";
@NAPS		= ('pb', 'mae-east', 'sprint', 'aads');
#@NAPS		= ('aads');
$RTBUILDPROG    = "/statistics/bin/rtbuild.pl";


foreach $nap (@NAPS) {
    $lastrib = &get_last_rib ($nap);
    $outrib = &get_out_rib ($nap);
    $outfile = "$DATAPATH/$nap/$outrib";


    @files = get_log_files ($lastrib, $nap);
	
    #print "last = $last\n";
    #print "@files\n";
    if ($#files == -1) {
	print "No log files to read!\n";
	next;
    }

    if ($lastrib ne "") {
	$lastrib = "-i $DATAPATH/$nap/RibIn.$lastrib";
	print "Reading last rib $lastrib\n";
    }
    print "$RTBUILDPROG -o $outfile $lastrib  @files\n";
    $out = `$RTBUILDPROG -o $outfile $lastrib @files`;
    print "$out";
}



# find last RIB created in data spool area. Return the date-time
# part
sub get_last_rib {
    local ($nap) = @_;

    $dir = "$DATAPATH/$nap/";
    opendir (DIR, $dir) || die "Could not open directory $dir: $!\n";
    
    @files = readdir (DIR);

    foreach $file (@files) {
	if ($file =~ /RibIn\.(.*)/) {
	    push (@last, $1);
	}
    }
    @last = sort (@last);
    $last = pop (@last);

    closedir (DIR);

    return $last;
}


# based on current time, create name of out rib file in date-time format
sub get_out_rib {
    local ($nap) = @_;

    ($sec, $min, $hour, $mday, $mon, $year, @junk) = localtime (time);

    $mon += 1;
    if ($mday < 10) {$mday = "0$mday";}
    if ($mon < 10) {$mon = "0$mon";}
    if ($sec < 10) {$sec = "0$sec";}
    if ($hour < 10) {$hour = "0$hour";}
    if ($min < 10) {$min = "0$hour";}
    
    return ("RibIn.$year$mon$mday-$hour$min$sec");
}



# search raw data BGP update files for evreything after 
# a given date (speicied as date-time
sub get_log_files {
    local ($l, $nap) = @_;
    my @list;

    ($a1, $a2, $a3, $tday, $tmon, $tyear, @junk) = localtime (time);
    $tmon++;

    $l =~ (/(\d\d)(\d\d)(\d\d)-(\d\d)(\d\d)(\d\d)/);
    $year = $1; $month = $2; $day = $3;
    #print "$year $month $day\n";

    $dir = "$DATAPATH/$nap";
    opendir (DIR, $dir) || die "Could not open directory $dir: $!\n";
    @files = readdir (DIR);
    
    foreach $file (@files) {
	if ($file =~ /recv.(\d\d)(\d\d)(\d\d)/) {
	    $out = "$DATAPATH/$nap/$file";

	    $_year = $1; $_month = $2; $_day = $3;

	    # not today
	    if (($_year == $tyear) && ($_month == $tmon) &&
		($_day == $tday)) {
		print "SKIPPING TODAY $out\n";
		next;
	    }

	    if ($_year < $year) {next;}
	    if ($_year > $year) {push (@list, $out); next;}

	    if ($_month < $month) {next;}
	    if ($_month > $month) {push (@list, $out); next;}

	    if ($_day < $day) {next;}
	    if ($_day > $day) {push (@list, $out);next;}

	    # current day?
	}
    }

    closedir (DIR);
    return (@list);
}
