/*
 * $Id: packet.c,v 1.13 1996/12/23 14:37:37 masaki Exp $
 */



#include <mrt.h>

#ifdef HAVE_IPV6
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <trace.h>
#include <ripng.h>
#include <interface.h>


/* ripng_process_packet
 * Given 1) the gateway we received the packet from, 2) a pointer to the packet,
 * and 3) the length (num bytes) of the packet, munge the packet making a linked
 * list of prefix and attribute tuples
 */
int ripng_process_packet_response (gateway_t *gateway, char *update, int bytes,
	   LINKED_LIST *ll_prefixes, LINKED_LIST *ll_attr) {
   char *cp;
   prefix_t *prefix6;
   prefix_t *nexthop = Ref_Prefix (gateway->prefix);
   ripng_attr_t *p_attr;
   struct in6_addr addr6, temp6;
   u_char *addr = (u_char *) &addr6;
   struct in6_addr allzero;
   char tmp[MAXLINE];

   memset (&allzero, 0, sizeof (allzero));

#define RIPNG_RTELEN 20

if ((bytes % RIPNG_RTELEN) != 0) {
     trace (NORM, RIPNG->trace, "RIPNG invalid RTE size %d\n", bytes);
}

   cp = update;

   while (cp < update + bytes) {
     u_short	tag;
     u_char	prefixlen, metric;

     if ((update + bytes) - cp < RIPNG_RTELEN)
	break;
     assert ((update + bytes) - cp >= RIPNG_RTELEN);
     /* copy prefix */
     memcpy (addr, cp, 16);
     cp += 16;

     UTIL_GET_SHORT (tag, cp);
     tag = ntohs (tag);
     UTIL_GET_BYTE (prefixlen, cp);
     UTIL_GET_BYTE (metric, cp);
     
#if 0
     trace (TR_PACKET, RIPNG->trace, 
        "  recv %s/%d metric %d tag %d\n", 
        inet_ntop (AF_INET6, addr, NULL, 0),
        prefixlen, metric, tag);
#endif

#define RIPNG_NEXT_HOP 0xff
     if (metric == RIPNG_NEXT_HOP) {
	 if (memcmp (addr, &allzero, 16) == 0) {
             trace (TR_PACKET, RIPNG->trace, 
                 "RIPNG nexthop is the originator itself %s\n", 
                 prefix_toa (gateway->prefix));
	     continue;
	 }
	 if (!ipv6_link_local_addr ((struct in6_addr *)addr)) {
             trace (NORM, RIPNG->trace, 
                 "RIPNG nexthop %s but not link-local address from %s\n", 
	         inet_ntop (AF_INET6, addr, tmp, sizeof (tmp)),
                 prefix_toa (gateway->prefix));
	     continue;
	 }
         trace (TR_PACKET, RIPNG->trace, 
             "  nexthop %s\n", 
	     inet_ntop (AF_INET6, addr, NULL, 0));
	 if (prefixlen != 0 && tag != 0)
             trace (NORM, RIPNG->trace, 
"RIPNG non-zero prefixlen (%d) or tag (%d) in specifying nexthop %s from %s\n", 
	         prefixlen, tag, 
                 inet_ntop (AF_INET6, addr, tmp, sizeof (tmp)),
                 prefix_toa (gateway->prefix));
	 Deref_Prefix (nexthop);
         nexthop = New_Prefix (AF_INET6, (u_char *) addr, 128);
     }
     else {
         prefix6 = New_Prefix (AF_INET6, (u_char *) addr, prefixlen);
         p_attr = New_Ripng_Attr (metric);
         p_attr->gateway = gateway;
         p_attr->nexthop = Ref_Prefix (nexthop);
         p_attr->metric = metric;
         p_attr->tag = tag;
    
         LL_Add (ll_prefixes, prefix6);
         LL_Add (ll_attr, p_attr);
     }
   }
}


/* ripng_process_packet_request
 * Given 1) the gateway we received the packet from, 2) a pointer to the packet,
 * and 3) the length (num bytes) of the packet, fill up metrics if exists
 *
 * return value 0: ordinal request
 *              1: whole-table request
 */
int ripng_process_packet_request (struct sockaddr_in6 *from, char *update, 
       int bytes, interface_t *interface) {
   char *cp;
   prefix_t prefix, *prefix6 = &prefix;
   struct in6_addr allzero;
   ripng_route_t *route;
   struct in6_addr addr6;
   u_char *addr = (u_char *) &addr6;
   int n = 0;

   memset (&allzero, 0, sizeof (allzero));
   cp = update;

   prefix6->family = AF_INET6;
   prefix6->bitlen = 128;
   memcpy (&prefix6->add.sin6, &from->sin6_addr, 16);

   while (cp < update + bytes) {
     u_short	tag;
     u_char	prefixlen;
     char	metric;

     assert ((update + bytes) - cp >= RIPNG_RTELEN);
     /* copy prefix */
     memcpy (addr, cp, 16);
     cp += 16;

     UTIL_GET_SHORT (tag, cp);
     tag = ntohs (tag);
     UTIL_GET_BYTE (prefixlen, cp);
     UTIL_GET_BYTE (metric, cp);
     
     if (cp == update+bytes && metric == RIPNG_INFINITY &&
	     prefixlen == 0 &&
	     /* tag == 0 && */
	     memcmp (addr, (char *) &allzero, sizeof (addr)) == 0) {
         trace (TR_PACKET, RIPNG->trace, "  whole-table request, responding\n");
	 return (-1);
     }

     prefix6->family = AF_INET6;
     prefix6->bitlen = 128;
     memcpy (prefix_tochar (prefix6), addr, 16);

     if (route = HASH_Lookup (RIPNG->hash, prefix6)) {
         tag = route->attr->tag;
         if (ntohs (from->sin6_port) == RIPNG_DEFAULT_PORT &&
            ipv6_link_local_addr (&from->sin6_addr)) {
            /* router's query, apply policy for that interface */
            if ((metric = ripng_policy (prefix6, route->attr, interface)) < 0) {
               metric = RIPNG_INFINITY;
            }
         }
         else {
           trace (TR_PACKET, RIPNG->trace, "  o %s/%d metric %d\n",
              prefix_toa (prefix6), prefix6->bitlen, metric);
         }
     }
     else {
	 metric = RIPNG_INFINITY;
	 /* tag = 0; /* ID doesn't specify -- masaki */
         trace (TR_PACKET, RIPNG->trace, "  x %s/%d metric %d (no exist)\n",
            prefix_toa (prefix6), prefix6->bitlen, metric);
     }
     cp -= 4;
     UTIL_PUT_SHORT (htons (tag), cp);
     UTIL_PUT_BYTE (prefixlen, cp);
     UTIL_PUT_BYTE (metric, cp);
     n++;
   }
   return (n);
}

#endif /* HAVE_IPV6 */
