/* 
 * $Id: user.c,v 1.15 1997/02/01 01:19:43 masaki Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <mrt.h>
#include <trace.h>
#include <select.h>
#include <stdarg.h>
#include <user.h>


int control = 0;

int		uii_proccess_command (uii_connection_t *uii_connection);
int		uii_destroy_connection (uii_connection_t *connection);
char*		uii_parse_line (char **line);
int		uii_read_command (uii_connection_t *uii);

/* globals */
uii_t *UII;
/* int UII_negate;*/


void uii_schedule_receive_command (uii_connection_t *uii_connection) 
{
  schedule_event (uii_connection->schedule, (void *) uii_read_command, 1,
		  uii_connection);
}


/* _start_uii
 * uii thread on its own
 */
void start_uii (uii_connection_t *uii_connection) {

  /* start timer to timeoutinactive connection */
  u_char l;


  l =0xff;
  write (uii_connection->sockfd, &l, 1);
  l =0xfb;
  write (uii_connection->sockfd, &l, 1);
  l =0x01;
  write (uii_connection->sockfd, &l, 1);

  l =0xff;
  write (uii_connection->sockfd, &l, 1);
  l =0xfb;
  write (uii_connection->sockfd, &l, 1);
  l =0x03;
  write (uii_connection->sockfd, &l, 1);
  
  l =0xff;
  write (uii_connection->sockfd, &l, 1);
  l =0xfe;
  write (uii_connection->sockfd, &l, 1);
  l =0x21;
  write (uii_connection->sockfd, &l, 1);

  /* no lflow */
  l =0xff;
  write (uii_connection->sockfd, &l, 1);
  l =0xfe;
  write (uii_connection->sockfd, &l, 1);
  l =0x22;
  write (uii_connection->sockfd, &l, 1);

  /* don't goahead */
  l =0xff;
  write (uii_connection->sockfd, &l, 1);
  l =0xfe;
  write (uii_connection->sockfd, &l, 1);
  l =0x03;
  write (uii_connection->sockfd, &l, 1);

  uii_send_data (uii_connection, "MRT version %s\r\n", MRT_VERSION);

  /* state 0 is requires authentication */
  if (UII->initial_state == 0) {
    uii_send_data (uii_connection, "\r\nUser Access Verification\r\n\r\n");
  }
  else if (UII->initial_state == 1) {
    uii_send_data (uii_connection, "\r\nNo Access Verification\r\n\r\n");
  }

/*  memset (uii_connection->buffer, 0, MAXLINE); */
  uii_connection->cp  = uii_connection->buffer;
  uii_connection->end  = uii_connection->buffer;
  uii_connection->end[0] = '\0';

  select_add_fd (uii_connection->sockfd, 1, 
		 uii_schedule_receive_command, uii_connection);


  uii_send_data (uii_connection, "[%2d] ", pthread_self ());
  uii_send_data (uii_connection, UII->prompts[uii_connection->state]);


#ifdef HAVE_LIBPTHREAD  
  while (1) {
    schedule_wait_for_event (uii_connection->schedule);
  }
#else
   return;
#endif /* HAVE_LIBPTHREAD */

}


/* uii_cept_connection
 * start thread for new connection and start connection timeout
 * timer.
 */
int uii_accept_connection () {
  int sockfd;
  int len;
  struct sockaddr_in addr;
  uii_connection_t *uii_connection;
  u_int one = 1;
  char tmp[MAXLINE];

  len = sizeof (addr);
  memset ((struct sockaddr *) &addr, 0, len);

  if ((sockfd = 
       accept (UII->sockfd, (struct sockaddr *) &addr, &len)) < 0) {
    trace (NORM, UII->trace, "ERROR -- UII Accept failed\n",
	   strerror(errno));
    return (-1);
   }

  if (setsockopt (sockfd, IPPROTO_TCP, TCP_NODELAY, (char *) &one, 
		  sizeof (one)) < 0) {
    perror ("setsockopt failerd: ");
    exit (0);
  }


  select_enable_fd (UII->sockfd);

  trace (NORM|INFO, UII->trace, "UII accepting connection from %s\n", 
	 inet_ntoa (addr.sin_addr));

  uii_connection = New (uii_connection_t);
  uii_connection->state = UII->initial_state;
  uii_connection->schedule = New_Schedule ("uii_connection", UII->trace);
  uii_connection->sockfd = sockfd;
  uii_connection->cmdcp = uii_connection->cmdend = 0;

  LL_Add (UII->ll_uii_connections, uii_connection);

  sprintf (tmp, "UII from %s", inet_ntoa (addr.sin_addr));
  mrt_thread_create (tmp, uii_connection->schedule, 
     start_uii, uii_connection);
  return (1);
}


static int
commands_compare (uii_command_t *a, uii_command_t *b) {
    return (strcasecmp (a->string, b->string));
}

/* 
 * initialize user interactive interface 
 */
int init_uii (trace_t *ltrace) {
  struct sockaddr_in serv_addr;
  struct servent *service;
  int optval;
  int i;

  assert (UII == NULL);
  UII = (uii_t *) New (uii_t);
  UII->ll_uii_commands = LL_Create (LL_CompareFunction, commands_compare,
			       LL_AutoSort, True, 0);
  UII->ll_uii_connections = LL_Create (0);
  UII->trace = trace_copy (ltrace);

   /* initialize prompts */
   for (i=0; i < UII_MAX_STATE; i++) {
     UII->prompts[i] = strdup ("mrt> ");
   }

}


/* for compatibility */
int listen_uii () {
    return listen_uii2 ("mrt");
}

/*
 * begin listening for connections on a well known port
 */
int listen_uii2 (const char *port) {
  struct sockaddr_in serv_addr;
  struct servent *service;
  int optval;

#if 0
  init_select ();
#endif

   /* check that NOT listening to portmaster! */
   memset ((char *) &serv_addr, 0, sizeof (serv_addr));

   serv_addr.sin_family = AF_INET;
   serv_addr.sin_addr.s_addr = INADDR_ANY;

   /* search /etc/services for port */
   if ((service = getservbyname (port, NULL)) == NULL) {
     int i = atoi (port); /* in case of number */
     serv_addr.sin_port = (i > 0)? htons (i): htons (UII_DEFAULT_PORT);
   }
   else 
     serv_addr.sin_port = service->s_port;

   if ((UII->sockfd = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
     trace (FATAL, UII->trace, "ERROR -- Could not get socket (%s)\n",
	    strerror (errno));
      return (-1);
   }
   
   optval = 1;
   if (setsockopt (UII->sockfd, SOL_SOCKET, SO_REUSEADDR, 
		   (const char *) &optval, sizeof (optval)) < 0) {
     trace (NORM, UII->trace, "ERROR -- Could setsocket (%s)\n",
	    strerror (errno));
   }

   if (bind (UII->sockfd, 
	     (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0) {
     trace (NORM|INFO, UII->trace, "ERROR -- Could not bind to port %d (%s)\n",
	     ntohs (serv_addr.sin_port), strerror (errno));
     return (-1);
   }

   listen (UII->sockfd, 5);

   trace (NORM, UII->trace, 
	  "UII listening for connections on port %d (socket %d)\n", 
	  ntohs (serv_addr.sin_port), UII->sockfd);

   select_add_fd (UII->sockfd, 1, (void *) uii_accept_connection, NULL);

   return (1);
}



/* uii_send_data
 * send formatted data out a socket
 */
int uii_send_data (uii_connection_t *uii, ...) {
   va_list ap;
   char *format;
   char line[MAXLINE];
   short size;
   fd_set fdvar_write;
   int total;
   int nn;
   int fd;

   char *cp = line;

   if (uii == NULL) {return (-1);}
   fd = uii->sockfd;
   if (fd <= 0) {return 0;}

   va_start (ap, uii);

   memset (line, 0, MAXLINE);

   format = va_arg(ap, char *);

   vsprintf (cp, format, ap);

   size = strlen (cp);
   /*UTIL_PUT_SHORT (size, psize);*/

   FD_ZERO (&fdvar_write);
   FD_SET(fd, &fdvar_write);

   total = 0;
   cp = line;

   while (total < size) {
      if (select (FD_SETSIZE, NULL, &fdvar_write, NULL, NULL) < 0) {
	 perror ("\nSelect failed");
	 exit (0);
      }

      if ((nn = write (fd, cp, size - total)) < 0) {
	 return (-1);
      }

      total += nn;
      cp += nn;
      
   }

   return (1);
}


/*
 * The following routines expect some basic terminal capabilities:
 *     0x07 -- beep
 *     0x08 -- non destractive backspace
 *  vt100-like arrow keys: ^[[A, B, C, and D
 * caution: when exceeding the right end of line will be a problem
 */

static void uii_erase (int fd, int n) {
    char bs = 0x08;
    char space = ' ';;
    while (n--) {
        write (fd, &bs, 1);
        write (fd, &space, 1);
        write (fd, &bs, 1);
    }
}


static void uii_bs (int fd, int n) {
    char bs = 0x08;
    while (n--) {
        write (fd, &bs, 1);
    }
}

static void uii_bell (int fd) {
    char bell = 0x07;
    write (fd, &bell, 1);
}


int uii_read_command (uii_connection_t *uii) {
  int n;
  u_char *cp;
  u_char l;
  
  /* memset (uii->tmp, 0, MAXLINE); */

  if ((n = read (uii->sockfd, uii->tmp, MAXLINE-1)) <= 0) {
    perror ("read failed: ");
    shutdown (uii->sockfd, 2);
    return (-1);
  }
  uii->tmp[n] = '\0';

  cp = uii->tmp;
  while (n--) {
    if (control == 1) {
      if (*cp == '[') {
        control = 2;
        cp++;
      }
      else {
        control = 0;
        cp++;
      }
    }
    else if (control == 2) {
      control = 0;
      
      /* up \020 */
      if (*cp == 'A') {
up:
	if (--uii->cmdcp < 0)
	  uii->cmdcp = MAXHIST -1;
	if (uii->cmds[uii->cmdcp][0] == '\0') {
	  uii_bell (uii->sockfd);
	  if (++uii->cmdcp >= MAXHIST)
	    uii->cmdcp = 0;
	}
	else {
	  int len, i, m;

replace:
	  if (uii->cp - uii->buffer > 0)
	    uii_bs (uii->sockfd, uii->cp - uii->buffer);
	  strcpy (uii->buffer, uii->cmds[uii->cmdcp]);
	  len = strlen (uii->buffer);
	  write (uii->sockfd, uii->buffer, len);
	  if ((m = uii->end - uii->buffer - len) > 0) {
	    for (i = 0; i < m; i++)
	      write (uii->sockfd, " ", 1);
	    uii_bs (uii->sockfd, m);
	  }
	  uii->cp = uii->end = uii->buffer + len;
	}
      }
      /* down \016 */
      else if (*cp == 'B') {
down:
	if (++uii->cmdcp >= MAXHIST)
	  uii->cmdcp = 0;
	if (uii->cmds[uii->cmdcp][0] == '\0') {
	  uii_bell (uii->sockfd);
	  if (--uii->cmdcp < 0)
	    uii->cmdcp = MAXHIST -1;
	}
	else {
	  goto replace;
        }
      }
      /* left */
      else if (*cp == 'D') {
left:
        if (uii->cp <= uii->buffer) {
          uii_bell (uii->sockfd);
        }
	else {
	  uii->cp--;
	  uii_bs (uii->sockfd, 1);
	}
      }
      /* right */
      else if (*cp == 'C') {
right:
        if (uii->cp >= uii->end) {
	  uii_bell (uii->sockfd);
        }
	else {
	  write (uii->sockfd, uii->cp, 1);
	  uii->cp++;
        }
      }
      cp++;
    }
    /* ^B */
    else if (*cp == 'B' - '@') {
      goto left;
    }
    /* ^F */
    else if (*cp == 'F' - '@') {
      goto right;
    }
    /* ^N */
    else if (*cp == 'N' - '@') {
      goto down;
    }
    /* ^P */
    else if (*cp == 'P' - '@') {
      goto up;
    }
    /* ^K */
    else if (*cp == 'K' - '@') {
	int i, m;

	if ((m = uii->end - uii->cp) > 0) {
	    for (i = 0; i < m; i++)
	    	write (uii->sockfd, " ", 1);
	    uii_bs (uii->sockfd, m);
	    uii->end = uii->cp;
	    uii->end[0] = '\0';
	}
    }
    /* ^U */
    else if (*cp == 'U' - '@') {
	int i, m;

	if ((m = uii->end - uii->buffer) > 0) {
	    uii_bs (uii->sockfd, uii->cp - uii->buffer);
	    for (i = 0; i < m; i++)
	    	write (uii->sockfd, " ", 1);
	    uii_bs (uii->sockfd, m);
	    uii->cp = uii->end = uii->buffer;
	    uii->end[0] = '\0';
	}
    }
    /* ^D */
    else if (*cp == 'D' - '@') {

      if (uii->cp >= uii->end) {
	uii_bell (uii->sockfd);
      }
      else {
	memmove (uii->cp, uii->cp+1, uii->end - uii->cp+1);
	uii->end--;
	write (uii->sockfd, uii->cp, uii->end - uii->cp);
	write (uii->sockfd, " ", 1);
	uii_bs (uii->sockfd, uii->end - uii->cp +1);
      }
    }
    else if (*cp == '\b' || *cp == '\177') {

      /* no more to delete -- send bell */
      if (uii->cp <= uii->buffer) {
	uii_bell (uii->sockfd);
      }
      else {
	uii_bs (uii->sockfd, 1);
	memmove (uii->cp-1, uii->cp, uii->end - uii->cp);
	uii->cp--;
	uii->end--;
	write (uii->sockfd, uii->cp, uii->end - uii->cp);
	write (uii->sockfd, " ", 1);
	uii_bs (uii->sockfd, uii->end - uii->cp +1);
      }
    }
#ifdef notdef
    else if (*cp =='\t') {
      uii_send_data (uii, "\r\nSorry, command completion is not working yet\r\n");
      memset (uii->buffer, 0, MAXLINE);
      uii->end = uii->buffer;
      uii->cp = uii->buffer;
      
      select_enable_fd (uii->sockfd);
      uii_send_data (uii, "[%2d] ", pthread_self ());
      uii_send_data (uii, UII->prompts[uii->state]);
      return (1);
    }
#endif
    /* control character (escape followed by 2 bytes */
    else if (*cp == '\033') {
      control = 1;
      cp ++;
    }
    /* ^C */
    else if (*cp == 'C' - '@') {
      uii->cp = uii->end = uii->buffer;
      uii->end[0] = '\0';
      goto xxxx;
    }
    else if (*cp == '\r') {
      /* printf ("NEWLINE\n"); */

/*      *cp = '\0'; */
      uii->end[0] = '\0';

  /* remove tailing spaces */
  cp = uii->buffer + strlen (uii->buffer) -1;
  while (cp >= uii->buffer && isspace (*cp)) {
      *cp = '\0';
      cp--;
  }

  /* remove heading spaces */
  cp = uii->buffer;
  while (*cp && isspace (*cp)) {
      cp++;
  }
  if (uii->buffer != cp)
      strcpy (uii->buffer, cp);

      uii->cp = uii->buffer;
xxxx:
      uii_send_data (uii, "\n\r");

      if (uii->buffer[0] != '\0') {
	strcpy (uii->cmds[uii->cmdend], uii->buffer);
	if (++uii->cmdend >= MAXHIST)
	  uii->cmdend = 0;
	uii->cmdcp = uii->cmdend;
	if (uii_proccess_command (uii) == UII_EXIT) {
	  /* user has quit or we've unexpetdly terminated */
	  /* delete uii memory here -- or maybe not. I think it is already deleted */
	  return (1);
	}
      }

/*      memset (uii->buffer, 0, MAXLINE); */
      uii->cp = uii->buffer;
      uii->end = uii->buffer;
      uii->end[0] = '\0';
      
      select_enable_fd (uii->sockfd);
      uii_send_data (uii, "[%2d] ", pthread_self ());
      uii_send_data (uii, UII->prompts[uii->state]);
      return (1);
    }
    else if (*cp == 0xff) {
      /*printf ("telnet sequences\n");*/
      cp += 3; n -= 2;
    }
    else {
      char *star = "*";
      if ((*cp >31) && (*cp < 177)) {
	if (uii->state == 0) /* no echo -- password state */ 
	  write (uii->sockfd, star, 1);
	else
	  write (uii->sockfd, cp, 1);
	if (uii->end > uii->cp) {
	  write (uii->sockfd, uii->cp, uii->end - uii->cp);
	  uii_bs (uii->sockfd, uii->end - uii->cp);
	  memmove (uii->cp+1, uii->cp, uii->end - uii->cp);
	}
	*(uii->cp)++ = *cp;
	uii->end++;
      }
      cp++;
    }
  }
    
  select_enable_fd (uii->sockfd);
  return (1);
}



/* uii_process_command
 * read command from socket and call appropraiet handling
 * function.
 */
int uii_proccess_command (uii_connection_t *uii) {
  char *line, *token;
  uii_command_t *uii_command;
  line = uii->buffer;
  uii->cp = uii->buffer;
  

   /* built-in functions */
   if ((!strcasecmp (uii->cp, "exit")) || 
       (!strcasecmp (uii->cp, "quit"))) {
     if (uii->state > UII_CONFIG) {
       uii->state = UII_CONFIG;
       return (1);
     }
     else if (uii->state == UII_CONFIG) {
       uii->state = UII_NORMAL;
       return (1);
     }
     else {
       uii_destroy_connection (uii);
     }
     return (UII_EXIT);
   }

   if (!strcasecmp (uii->cp, "kill")) {
      mrt_exit (0);
   }

   if (!strncasecmp (uii->cp, "no ", 3)) {
     uii->cp += 3;
   }

   /* blank line */
   if ((token = uii_parse_line (&line)) == NULL)
     return (1);

   /* itterate through function list 
    * 1) for longest match
    * 2) for bext match (assume rest are command specific data)
    */
   LL_Iterate (UII->ll_uii_commands, uii_command) {
     if (uii->state != uii_command->state) continue;
     if (!strncasecmp (uii->cp, uii_command->string, 
		       strlen (uii->cp)) /* &&
	 (uii_command->string [strlen (uii->cp)] == '\0' ||
	  isspace (uii_command->string [strlen (uii->cp)])) */) {
       uii->cp = uii->buffer + strlen (uii->cp);
       return (uii_command->call_fn (uii));
     }
   }
/* LL_Iterate (UII->ll_uii_commands, uii_command) { */
   LL_IterateBackwards (UII->ll_uii_commands, uii_command) { 
     if (uii->state != uii_command->state) continue;
     if (!strncasecmp (uii->cp, uii_command->string, 
		       strlen (uii_command->string)) /* &&
	 (uii->cp [strlen (uii_command->string)] == '\0' ||
	  isspace (uii->cp [strlen (uii_command->string)])) */) {
       uii->cp = uii->buffer + strlen (uii_command->string);
       return (uii_command->call_fn (uii));
     }
   }
   
   if (strcasecmp (uii->cp, "help") == 0 ||
       *(line + strlen(line) - 1) == '?') {
     LL_Iterate (UII->ll_uii_commands, uii_command) {
       if (uii_command->state == uii->state) {
	 uii_send_data (uii, "  %s\r\n", uii_command->string);
       }
     }
     uii_send_data (uii, "  %s\r\n", "quit");
     uii_send_data (uii, "  %s\r\n", "help");
     return (1);
   }

   /* default */
   uii_send_data (uii, "Unrecognized Command: %s\r\n", uii->cp);
   return (-1);
}



char *uii_parse_line (char **line) {
  char *cp = *line, *start;
  static char word[100];
  memset (word, 0, 100);

  /* skip spaces */
  while (*cp && isspace (*cp)) cp++;
    
  start = cp;
  while (!isspace (*cp) && (*cp != '\0') && (*cp != '\n'))
    cp++;

  if ((cp - start) > 0) {
    memcpy (word, start, cp - start);
    word[cp-start] = '\0';
    *line = cp;
    return (word);
  }

  return (NULL);
}


/* uii_add_command
 * Add a command (i.e. "show rip") and accompagnying call
 * function to list maintaned by user interface object
 */
int uii_add_command (int state, char *string, int (*call_fn)()) 
{
  uii_command_t *command;

  command = New (uii_command_t);
  memcpy (command->string, string, 100);
  command->call_fn = call_fn;
  command->state = state;
  LL_Add (UII->ll_uii_commands, command); 

  return (1);
}


int uii_destroy_connection (uii_connection_t *connection) {
  select_delete_fd (connection->sockfd);
  shutdown (connection->sockfd, 2);
  /* kill scedhule */

  LL_Remove (UII->ll_uii_connections, connection);
  Delete (connection);
  
  mrt_thread_exit ();
}





/* parse_line
 * %p prefix
 */
int parse_line (char *line, char *format, ...) 
{
  va_list	ap;
  void		**arg;
  u_int		*intarg;
  char		*chararg;
  char		*token, *fcp;
  u_int		match, l;

  int           state;

  prefix_t	*prefix;

#ifdef HAVE_IPV6
  struct sockaddr_in6 sin6;
#endif /* HAVE_IPV6*/

  match = 0;
  state = 0;
  va_start(ap, format);

  fcp = format;
  for (fcp; *fcp != '\0'; fcp++) {

    /* eat up spaces */
    if (isspace (*fcp)) {
      while (isspace (*line)) line++;
      continue;
    }

   if (*line == '\n' || *line == '\0')
      return (match);

    /* literal */
    if (*fcp != '%') {

      if (*fcp != *line)
         return (match);
      while (*fcp && !isspace(*fcp) && *fcp == *line) {
	/*printf ("\n%s %s", *fcp, *line);*/
	fcp++;
	line++;
      }
      if ((isspace (*line) || *line == '\n' || *line == '\0') &&
          (isspace (*fcp) || *fcp == '\0')) {
        match++;
        fcp--;
        continue;
      }
      else {
        return (match);
      }
    }

    /* argument */
    else {
      fcp++;
      if (*fcp == 'p') {
	if ((token = uii_parse_line (&line)) == NULL) goto finish;
        if (strchr (token, ':')) goto finish; /* assuming it ipv6 addr */
	if ((prefix = ascii2prefix (AF_INET,  token)) == NULL) goto finish;
	match++;
	arg = va_arg (ap, void**);
	*arg = prefix;
      }
#ifdef HAVE_IPV6
      if (*fcp == 'P') {
	if ((token = uii_parse_line (&line)) == NULL) goto finish;
        if (!strchr (token, ':')) goto finish; /* assuming it non ipv6 addr */
	if ((prefix = ascii2prefix (AF_INET6,  token)) == NULL) goto finish;
	match++;
	arg = va_arg (ap, void**);
	*arg = prefix;
      }
#endif /* HAVE_IPV6 */
      if (*fcp == 'd') {
	if ((token = uii_parse_line (&line)) == NULL) goto finish;
        if (!isdigit (*token)) goto finish;
	intarg = va_arg (ap, int*);
	l = atol (token);
	memcpy (intarg, &l, 4);
	match++;
      } 
      if (*fcp == 's') {
	if ((token = uii_parse_line (&line)) == NULL) goto finish;
        if (!isalpha (*token)) goto finish; /* this may be so strict */
	chararg = va_arg (ap, char*);
	strcpy (chararg, token);
	match++;
      } 
      /* gobble up everything to the end of the line */
      if (*fcp == 'S') {
	/*if ((token = uii_parse_line (&line)) == NULL) {return (-1);}*/
	chararg = va_arg (ap, char*);
	strcpy (chararg, line);
	match++;
	return (match);
      }
    }
  }

finish:
  return (match);
}


/* set_trace
 */
int 
set_uii (uii_t *tmp, int first, ...)
{
   va_list    		ap;
   enum UII_ATTR	attr;
   int state;

   if (tmp == NULL) return (-1);


   /* Process the Arguments */
   va_start(ap, first);
   for (attr = (enum UII_ATTR)first; attr; 
	attr = va_arg(ap, enum UII_ATTR)) {
      switch (attr) {
      case UII_PROMPT:
	 state = va_arg(ap, int);
	 if ((state < 0) || state > UII_MAX_STATE) {return (-1);}
	 tmp->prompts[state] = strdup (va_arg(ap, char *));
	 break;
      default:
	 break;
      }
   }
   va_end(ap);

   return (1);
}

#ifndef HAVE_MEMMOVE
char *
memmove(char *dest, const char *src, size_t n) {

    if (n <= 0 || dest == src)
	return (dest);
    if (dest > src && dest < src+n) {
    /* copy from backward */
	while (n--)
            dest[n] = src[n];
    }
    else {
	register int i;
	for (i = 0; i < n; i++)
            dest[i] = src[i];
    }
    return (dest);
}
#endif
