/* 
 * $Id: pthread_fake.h,v 1.3 1996/12/23 14:36:30 masaki Exp $
 */

/* This is a compatability include file for systems that DO NOT 
 * has kernel pthreads or which are NOT using MIT pthreads library
 * This file just defines pthread functions as null routines
 */

#ifndef _PTHREADS_FAKE_H
#define _PTHREADS_FAKE_H

#define pthread_self() get_thread_id()

/* define as null function -- just ignore */
#define pthread_mutex_init(a, b)
#define pthread_mutex_trylock(a)	1
#define pthread_sigmask(a,b,c)
#define pthread_init()
#define pthread_cond_signal(a)
#define pthread_cond_wait(a,b)
#define pthread_cond_init(a,b)
#define pthread_mutex_unlock(a)
#define pthread_mutex_lock(a)

/* these aren't used -- just define them as ints to keep compiler happy */
typedef	unsigned int	pthread_t;
typedef unsigned int	pthread_mutex_t;
typedef unsigned int	pthread_cond_t;

#endif /* _PTHREADS_FAKE_H */
