/*
 * $Id: lbgp.h,v 1.5 1996/07/26 20:41:27 masaki Exp $
 */

#ifndef _LBGP_H
#define _LBGP_H  

#include <aspath.h>


/* destination preference attribute (Internet Draft) */
typedef struct _dpa_t {
  short		AS;
  u_long	value;
} dpa_t;

typedef struct _community_t {
  int		len;  /* the number of community values */
  u_long        *value;
} community_t;

typedef struct _bgp_attr_t {
  u_char	type;		/* ROUTE_ATTR_BGP4 */
  prefix_t*	nexthop;	/* next hop bgp attribute - make gateway? */
  int 		ref_count;	/* number of routes referencing this block */
  gateway_t	*gateway;	/* gateway learned from */
  /*short		local;		 local memory -- delete me when done */

  /* manditory */
  aspath_t*	aspath; 	/* BGP aspath */
  short		home_AS;	/* last AS in last segment of ll_as_seg */
  short		origin;		/* origin (IGP, EGP, UNKNOWN) of route */

  /* optional -- these should really be a linked list */
  short		attribs;	/* mask of non-mandatory attributes present */
  long		multiexit;
  long		local_pref;
  u_char	atomic_agg;
  dpa_t*	dpa;
  community_t*  community;
} bgp_attr_t;




enum BGP4_Optional_Attr_Bits {
   O_AGGREGATOR =	1,
   O_ATOMICAGG =	2, 
   O_LOCALPREF =	4,
   O_DPA =		8,
   O_COMMUNITY =	16,
};


#endif /* _LBGP_H */
