/*
 * $Id: interface.h,v 1.16 1996/12/23 14:36:26 masaki Exp $
 */

#ifndef _INTERFACE_H
#define _INTERFACE_H

/* Some of this code taken from Berkely routed software */

#include <mrt.h>
#include <trace.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>

#ifdef SOLARIS
#include <sys/sockio.h>
#endif

typedef struct _ll_addr_t {
  prefix_t	*prefix;		/* interface addresess */
  prefix_t	*broadcast;		/* destination or broadcast address
				   broadcast address is defined in case of v4
				   prefixlen will be ignored */
} ll_addr_t;

#define MAX_INTERFACES 32	/* the maximum is limited by the 'bit' field
                                   in the following structure */
typedef struct _interface_t {
  u_long	bit;		/* each interface assigned a unique bit */
  u_long	flags;		/* interface flags (from the ioctl) */
  u_long	mtu;		/* interface mtu (from the ioctl) */
  char		name[IFNAMSIZ+1];
  int		index;		/* index number */
  int		dlist_in[PROTO_MAX];  /* list num for input filtering */
  int		dlist_out[PROTO_MAX]; /* list num for output filtering */
  int		metric_in;	/* input metric */
  int		metric_out;	/* output metric */

  LINKED_LIST	*ll_addr;	/* address list */
  ll_addr_t	*primary;	/* primary address for ipv4 */
#ifdef HAVE_IPV6
  ll_addr_t	*primary6;	/* primary address for ipv6 (global) */
  ll_addr_t	*link_local;	/* ipv6 link local address */
#endif /* HAVE_IPV6 */

#define mrt_compat 1
#ifdef mrt_compat
/*
 * The following are defined for compatible purpose & easy use
 * and may be deleted after checking ipv4 routing protocols.
 */

  /* ipv4 */
  prefix_t	*prefix;
  u_long	dest;           /* we should merge dest & broadcast */
  u_long	broadcast;

#ifdef HAVE_IPV6
  /* ipv6 */
  prefix_t	*prefix6;		
  struct in6_addr dest6;	
#endif /* HAVE_IPV6 */
#endif /* mrt_compat */

} interface_t;

#define IFF_USERDEF	0x40000000 /* user defined interface, not physical */
#define IFF_TUNNEL	0x80000000 /* tunnel interface (special treatment
                                      when adding a route into the kernel) */

typedef struct _interface_master_t {
   u_long	number;		/* number of interfaces */
   interface_t	*default_interface;
   trace_t	*trace;
   LINKED_LIST  *ll_interfaces;		/* IPv4 & v6 Interfaces */
   u_long	max_mtu;	/* maximum MTU */
} interface_master_t;

extern interface_master_t *INTERFACE_MASTER;

/* public functions */
interface_t *new_interface (char *name, u_long flags, u_long mtu, int index);
interface_t *add_addr_to_interface (interface_t *interface, int family,
        char *addr, int len, char *broadcast);
int 	     init_interfaces (trace_t *ltrace);

interface_t*	find_interface (prefix_t *prefix);
interface_t*	find_interface_flags (prefix_t *prefix, int flags);
interface_t*	find_interface_byname (char *name); 
interface_t*	find_interface_byindex (int index);
interface_t*	find_interface_local (prefix_t *prefix);
LINKED_LIST*	find_network (prefix_t *prefix);
interface_t*	local_interface (int familly, u_char *cp);

int		show_interfaces (uii_connection_t *); 
int 		mask2len (u_char *mask, int bytes);
char*		len2mask (int bitlen, u_char *mask, int bytes);

#endif /* INTERFACE_H */
