/* Code style: -*- linux-c -*- */
/* File : rfc1897gen.c */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/ioctl.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <linux/if.h>
#include <linux/if_ether.h>	/* description of ethernet packets */

#include "range.h"

#define START	0x5F
#define RES	0x00

#define ASN	278

int main()
{
	struct node *details;

	int netaddr1, netaddr2, netaddr3;
	int subnet1, subnet2;
	int asn1, asn2;

	char fq_ipv6[40];

	details = if_setup();
	printf("\tYour IP address is     : %X\n", details->ip);
	printf("\tYour IP subnet mask is : %X\n", details->netmask);
	printf("\tYour IP broadcast is   : %X\n", details->broadcast);
	printf("\tYour MAC HW addr is    : %s\n",details->mac);
	
	/* don't ask,....  it's 1:50 in the morning and I'm out of coffee */

	netaddr1 = (details->ip) >> 24 | 0xFFFFFF00;
	netaddr1 -= 0xFFFFFF00;

	netaddr2 = (details->ip) >> 16 | 0xFFFFFF00;
	netaddr2 -= 0xFFFFFF00;

	netaddr3 = (details->ip) >> 8 | 0xFFFFFF00;
	netaddr3 -= 0xFFFFFF00;

	subnet1  = (details->broadcast) >> 8 | 0xFFFFFF00;
	subnet1  -= 0xFFFFFF00;

	subnet2  = (details->broadcast) | 0xFFFFFF00;
	subnet2	-= 0xFFFFFF00;

	asn1=(ASN>>8);
	asn2=(ASN&0xFF);

	printf("\n\tYour rfc1897 complient IPv6 address\n");

	sprintf(fq_ipv6, "%02X%02X:%02X%02X:%02X%02X:%02X%02X:%02X%02X:%s",
			START, asn1,
			asn2, RES,
			netaddr1, netaddr2,
			netaddr3, RES,
			subnet1, subnet2,
			details->mac);

	printf("\tAddrSpec :\t%s\n", fq_ipv6);
	printf("\tbase95   :\tnot yet available\n");



	return (0);
}


struct node * if_setup(void)
{
	/* the aim here is to :
		1) read out the ip address of the interface
		2) read out the netmask address of the interface
		3) read out the broadcast address of the interface
		4) return all this info in a structure we can use elsewhere
	*/

	struct node *local_if;
        struct ifreq ifr, oldifr;
        int sd;
        int ip, netmask, broadcast;
	char * mac;

        /* OPEN SOCKET  (ETH_P_ALL definition from <linux/if_ether.h>) */

        if ((sd = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
                perror ("Init_if: Can't get socket:");
                exit (1);
        }

	/* KLUDGE!!!!! note the hard coded eth0 */

        strcpy (oldifr.ifr_name, "eth0");
        if (ioctl (sd, SIOCGIFFLAGS, &oldifr) < 0) {
                close (sd);
                perror ("Can't get flags: ");
                exit (1);
        }


        ifr = oldifr;

        /* These lines is for intrested parties who always
	   wanted to know how to put the interface into promiscious mode

       	   ifr.ifr_flags |= IFF_PROMISC;
	*/


        if (ioctl (sd, SIOCSIFFLAGS, &ifr) < 0) {
                close (sd);
                perror ("Can't set flags: ");
                exit (1);
        }

        /* WHILE WE ARE AT IT GET THE IF DETAILS */
	/* (it's extremely annoying that we have to make 3 calls but thats life) */
	/* and to top it all off each of the following aparently 'corrupt' the various */
	/*  other fields between calls hense the need for the routine dig_out_ip*/

        /* interface address */
        if (ioctl (sd, SIOCGIFADDR, &ifr) < 0) {
                close (sd);
                perror ("Can't get address of interface: ");
                exit (1);
        }

        ip = dig_out_ip((unsigned char *)ifr.ifr_addr.sa_data);

        /* interface netmask */
        if (ioctl (sd, SIOCGIFNETMASK, &ifr) < 0) {
                close (sd);
                perror ("Can't get netmask: ");
                exit (1);
        }

        netmask = dig_out_ip((unsigned char *)ifr.ifr_netmask.sa_data);  

        /* interface broadcast */
        if (ioctl (sd, SIOCGIFBRDADDR, &ifr) < 0) {
                close (sd);
                perror ("Can't get broadcast: ");
                exit (1);
        }

        broadcast = dig_out_ip((unsigned char *)ifr.ifr_broadaddr.sa_data);

	/* before I forget,... get the MAC address */

        if (ioctl (sd, SIOCGIFHWADDR, &ifr) < 0) {
                close (sd);
                perror ("Can't get MAC hwaddr: ");
                exit (1);
        }

	mac = dig_out_mac((unsigned char *) ifr.ifr_ifru.ifru_hwaddr.sa_data);

	/* and now repackage the information in the net_atrtib structure */

	local_if = (struct node *) calloc(1, sizeof(struct node));

	local_if->ip = ip;
	local_if->netmask = netmask;
	local_if->broadcast = broadcast;
	local_if->mac = mac;

        return(local_if);
}


int dig_out_ip(const unsigned char *ip)
{
        /* *Sigh* where the hell was the nice fuction to get this? */
        /* the structure holds 14 bytes which is all well and nice */
        /* but no convient syscall to get *JUST* the ip */

        static char buffer[20]="";

        /* not the worlds neatest way of doing things, magic numbers time */

        sprintf(buffer, "%d.%d.%d.%d", ip[2], ip[3], ip[4], ip[5]);

        return (encode_ip(buffer));
}

char * dig_out_mac(const unsigned char *mac)
{
        /* *Sigh* where the hell was the nice fuction to get this? */
        /* the structure holds 14 bytes which is all well and nice */
        /* but no convient syscall to get *JUST* the ip */

        static char buffer[20]="";

        /* not the worlds neatest way of doing things, magic numbers time */

        sprintf(buffer, "%02X%02X:%02X%02X:%02X%02X",
		 mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

	return (buffer);
}		


int encode_ip(const char * number)
{
        unsigned int class_a;
        unsigned int class_b;
        unsigned int class_c;
        unsigned int class_d;
        unsigned int result=0;

        static char internal_buffer[20]=""; /* nessesary evil 
                                               (avoids segv's across text segments) */
        strcpy(internal_buffer, number);
  

        class_a = atoi(strtok(internal_buffer, "."));
        class_b = atoi(strtok(NULL, "."));
        class_c = atoi(strtok(NULL, "."));
        class_d = atoi(strtok(NULL, "."));
  
  
#ifdef DEBUG
        printf("encoded broke up these numbers %d %d %d %d\n", class_a, class_b, class_c, class_d);
#endif
  
        /* encode the numbers AA BB CC DD = 1 byte per number */
        /* the << is used here as a very fast multiply */

        result  = (class_d        +
                  (class_c << 8)  +
                  (class_b << 16) +
                  (class_a << 24) );
  
        return (result);
}

unsigned char decode(int number, int place)
{
/* this routime is *heavily* used so I've tried to optimise it */
        unsigned int a, b, c, d;
  
        /* masks :
           FF FF FF 00
           FF FF 00 FF
           FF 00 FF FF
           00 FF FF FF
           */
  
 /*        a = b = c = d = 0; */ /* not really needed */
  
        d = (number >> 0)  | 0xFFFFFF00;
        c = (number >> 8)  | 0xFFFFFF00;
        b = (number >> 16) | 0xFFFFFF00;
        a = (number >> 24) | 0xFFFFFF00;
  
        /* now mask out the high 0xFFFFFF-- bits */
  
        d -= 0xFFFFFF00;
        c -= 0xFFFFFF00;
        b -= 0xFFFFFF00;
        a -= 0xFFFFFF00;
  
        switch (place) {
        case 1	: return (a); break;
        case 2	: return (b); break;
        case 3	: return (c); break;
        case 4	: return (d); break;
        default	: perror("In decode, invalid arg[2]"); exit(1);
        };

	printf("Oh bugger something REALLY NASTY went wrong\n");
        return(0);              /* this is to shut up gcc -Wall
                                   as we never actually get here */
}

char * ip_to_str(int encoded_ip)
{
        /* damn,.. why isn't there a reverse for atoi? like itoa? */
  
        char buffer[12];        /* just make sure it's big enuogh */
	static char string[20];
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_A));
        strcpy(string, buffer);
        strcat(string, ".");
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_B));
        strcat(string, buffer);
        strcat(string, ".");
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_C));
        strcat(string, buffer);
        strcat(string, ".");
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_D));
        strcat(string, buffer);

  return (string);
}

void translate(char *string, int encoded_ip)
{
        /* again,.. why isn't there a reverse for atoi? like itoa? */
	/* someone go back to the ANSI C geeks and demand one please */
  
        char buffer[12];        /* just make sure it's big enuogh */
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_A));
        strcpy(string, buffer);
        strcat(string, ".");
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_B));
        strcat(string, buffer);
        strcat(string, ".");
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_C));
        strcat(string, buffer);
        strcat(string, ".");
  
        sprintf(buffer,"%d", decode(encoded_ip, CLASS_D));
        strcat(string, buffer);
  
}
