/* Code style: -*- linux-c -*- */
/* File : xfw/find/range.h */

/* needfulls */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <linux/if.h>   
#include <linux/if_ether.h>     /* description of ethernet packets */

 
typedef unsigned int address;	/* addresses held in coded form (2^n8) ie AABBCCDD */

struct node {
  address ip;                   /* holds the routers ip address in coded form */
  address netmask;              /* holds the netmask for this node */
  address broadcast;            /* holds the bradcast address for this node */
  char * mac;			/* HW address MAC */
};

#define CLASS_A 1
#define CLASS_B 2
#define CLASS_C 3
#define CLASS_D 4

/* prototypes used */

extern	int  		encode_ip		(const char *);
extern	int  		dig_out_ip		(const unsigned char *);
extern	unsigned char	decode			(int, int); 
extern	void		translate		(char *, int);
extern	char *		ip_to_str		(int encoded_ip);
extern	struct node *	if_setup		(void);
extern	char *		dig_out_mac		(const unsigned char *);
