/*
%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#ifndef _INNER_APPS_H
#define _INNER_APPS_H 1

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet6/in6.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <getopt.h>
#include <stdlib.h>
#include <unistd.h>

typedef union {
  struct sockaddr sa;
  struct sockaddr_in sin;
  struct sockaddr_in6 sin6;
  struct sockaddr_un sun;
} su;

#define HNAME_MAX 64
#define SNAME_MAX 32

void dump_sockaddr(struct sockaddr *sa, int len);

#ifdef VERSION
char *myname = (char *)0;

#define INIT(argc, argv) \
  { \
    char *__c; \
    \
    if ((__c = strrchr(argv[0], '/'))) \
      myname = strdup(++__c); \
    else \
      myname = strdup(argv[0]); \
  };

#define STDOPTS_FLAGS "Vh"
#define STDOPTS_CASES \
        case 'h': \
          printf("usage: %s " USAGE "\n", myname); \
	  exit(0); \
        case 'V': \
	  printf("%s: " NAME " version " VERSION "\n", myname); \
	  exit(0);
#endif /* VERSION */
#endif /* _INNER_APPS_H 1 */
