/*
%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

v0.02 - NOT FOR REDISTRIBUTION
*/
#define NAME "fingerd"
#define VERSION "v0.02 - NOT FOR REDISTRIBUTION"
#define USAGE "[-Vh] [-m mail host]"

#include <sys/types.h>
#include <sys/socket.h>
#include <pwd.h>
#include <grp.h>
#include <netdb.h>
#include <unistd.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ctype.h>

#include "support.h"
#include "inner-apps.h"

struct gidtoname_cache {
  struct gidtoname_cache *next;
  gid_t gid;
  char name[32];
};

struct gidtoname_cache *gidtoname_cache = NULL;

char *gidtoname(gid_t gid)
{
  struct gidtoname_cache **g, *g2;

  for (g = &(gidtoname_cache); *g; g = &((*g)->next)) {
    if ((*g)->gid == gid) {
      g2 = *g;
      *g = g2->next;
      g2->next = gidtoname_cache;
      gidtoname_cache = g2;
      return g2->name;
    };
  };

  if (!(g2 = malloc(sizeof(struct gidtoname_cache)))) {
    syslog(LOG_ERR, "malloc failed");
    exit(1);
  };

  {
    struct group *gr;
    if (!(gr = getgrgid(gid))) {
      syslog(LOG_ERR, "can't find name for gid %d", gid);
      exit(1);
    };
    strncpy(g2->name, gr->gr_name, sizeof(g2->name)-1);
    g2->name[sizeof(g2->name)-1] = 0;
  };

  g2->gid = gid;
  g2->next = gidtoname_cache;
  gidtoname_cache = g2;

  return g2->name;
};

int debug = 0;

int main(int argc, char **argv)
{
  char buffer[32];
  int i;
  char hbuf[64] = "command line", sbuf[16] = "";
  char *key = NULL;
  char *mailhost = NULL;

  INIT(argc, argv);

  openlog(myname, LOG_NDELAY | LOG_PID, LOG_DAEMON);

  mailhost = nrl_domainname();

  while ((i = getopt(argc, argv, STDOPTS_FLAGS "dm:")) != EOF) {
    switch(i) {
      case 'd':
        debug = 1;
        break;
      case 'm':
	mailhost = optarg;
	break;
      STDOPTS_CASES
    };
  };

  if (!mailhost) {
    syslog(LOG_ERR, "can't determine mail host");
    exit(1);
  };

  {
  struct stat stat;

  if (fstat(STDIN_FILENO, &stat) < 0) {
    syslog(LOG_ERR, "fstat failed: %s(%d)", strerror(errno), errno);
    exit(1);
  };

  if (S_ISSOCK(stat.st_mode)) {
    char sabuf[128];

    i = sizeof(sabuf);
    if (getpeername(STDIN_FILENO, (struct sockaddr *)sabuf, &i)) {
      syslog(LOG_ERR, "getpeername failed: %s(%d)", strerror(errno), errno);
      exit(1);
    };
    
    if (getnameinfo((struct sockaddr *)sabuf, i, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), NI_NUMERICHOST | NI_NUMERICSERV)) {
      syslog(LOG_ERR, "getnameinfo failed");
      exit(1);
    };
  };
  };

  memset(buffer, 0, sizeof(buffer));
  if ((i = read(STDIN_FILENO, buffer, sizeof(buffer)-1)) <= 0) {
    syslog(LOG_ERR, "read failed: %s(%d)", strerror(errno), errno);
    exit(1);
  };

  {
    char *c;

    for (c = buffer; *c && (isalnum(*c) || (*c == ' ')); c++);
    *c = 0;

    syslog(LOG_INFO, "query on '%s' from %s.%s", buffer, hbuf, sbuf);

    if (!(c = strtok(buffer, " ")))
      goto nokey;

    if (*c == '/')
      if (!(c = strtok(buffer, " ")))
	goto nokey;

    key = c;
  };

  {
    char *matches[8];
    struct group *g;
    int j, fuzzy = 1;

    memset(matches, 0, sizeof(matches));

    if (!(g = getgrnam("user"))) {
      syslog(LOG_ERR, "No group named 'user'");
      exit(1);
    };

    if (strlen(key) < 4)
      fuzzy = 0;

    for (i = j = 0; g->gr_mem[i]; i++)
      if ((fuzzy && strstr(g->gr_mem[i], key)) || (!fuzzy && strcmp(g->gr_mem[i], key))) {
	matches[j++] = g->gr_mem[i];
	if (j == (sizeof(matches)/sizeof(char *)))
	  goto toomany;
      };

    if (!j)
      goto nomatches;

    qsort((void *)matches, j, sizeof(char *), (void *)strcmp);

    {
      struct passwd *p;
      char planbuf[1024], plan[] = "/.plan";
      FILE *f;

      for (i = 0; i < j; i++) {
	if (!(p = getpwnam(matches[i]))) {
	  syslog(LOG_ERR, "'%s' is a member of group 'user', but not in password file!");
	  continue;
	};
	printf("%s [%s] %s@%s\r\n", p->pw_gecos, gidtoname(p->pw_gid), p->pw_name, mailhost);
        fflush(stdout);
	if (strlen(p->pw_dir) > sizeof(planbuf) - sizeof(plan))
	  continue;

	strcpy(planbuf, p->pw_dir);
	strcat(planbuf, plan);
	if ((f = fopen(planbuf, "r"))) {
	  fputs("\r\n", stdout);
	  while(fgets(planbuf, sizeof(planbuf), f)) {
	    fputs(" ", stdout);
	    fputs(planbuf, stdout);
	  };
	  fclose(f);
	  fflush(stdout);
	};
	write(STDOUT_FILENO, "\r\n", 2);
      };
    };
  };

  exit(0);

nokey:
  {
    char msg[] = "You didn't specify a search key.\r\n";
    write(STDOUT_FILENO, msg, sizeof(msg)-1);
    exit(0);
  };

toomany:
  {
    char msg[] = "Too many matches; use a more specific search key.\r\n";
    write(STDOUT_FILENO, msg, sizeof(msg)-1);
    exit(0);
  };

nomatches:
  {
    char msg[] = "No matches.\r\n";
    write(STDOUT_FILENO, msg, sizeof(msg)-1);
    exit(0);
  };
};
