/*
%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

v0.02 - NOT FOR REDISTRIBUTION
*/
#define NAME "fdsniff"
#define VERSION "v0.02 - NOT FOR REDISTRIBUTION"
#define USAGE "[-Vhq]"

#include <stdio.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <netdb.h>

#include "support.h"
#include "inner-apps.h"

struct inotoname {
  struct inotoname *next;
  ino_t ino;
  char *name;
} *inotonames = NULL;

struct dirname {
  struct dirname *next;
  char *name;
} *dirnames = NULL, **pd = &dirnames;

void inodesearch(char *dirname)
{
  DIR *dir;
  struct dirent *dirent;
  struct inotoname *inotoname;
  struct stat stat;
  char buffer[2048];

  if (!(dir = opendir(dirname))) {
    if ((errno == EACCES) || (errno == ENOENT))
      return;
    fprintf(stderr, "%s: opendir(%s): %s(%d)\n", myname, dirname, strerror(errno), errno);
    exit(1);
  };

  while((dirent = readdir(dir))) {
    if (!strcmp(dirent->d_name, ".") || !strcmp(dirent->d_name, ".."))
      continue;
    if (snprintf(buffer, sizeof(buffer), "%s%s%s", dirname, (dirname[strlen(dirname)-1] == '/') ? "" : "/", dirent->d_name) == sizeof(buffer)) {
      fprintf(stderr, "%s: snprintf: exceeded buffer size, dirname=%s, d_name=%s\n", myname, dirname, dirent->d_name);
      continue;
    };
    for (inotoname = inotonames; inotoname; inotoname = inotoname->next) {
      if (!inotoname->name && (inotoname->ino == dirent->d_ino)) {
        if (!(inotoname->name = malloc(strlen(buffer)))) {
          fprintf(stderr, "%s: malloc: %s(%d)\n", myname, strerror(errno), errno);
          exit(1);
        };
        strcpy(inotoname->name, buffer);
      };
    };
    if (lstat(buffer, &stat) < 0) {
      if ((errno == EACCES) || (errno == ENOENT))
	continue;
      fprintf(stderr, "%s: lstat(%s, ...): %s(%d)\n", myname, buffer, strerror(errno), errno);
      exit(1);
    };
    if (S_ISDIR(stat.st_mode)) {
      if (!(*pd = malloc(sizeof(struct dirname)))) {
	fprintf(stderr, "%s: malloc: %s(%d)\n", myname, strerror(errno), errno);
	exit(1);
      };
      memset(*pd, 0, sizeof(struct dirname));
      if (!((*pd)->name = malloc(strlen(buffer)+1))) {
	fprintf(stderr, "%s: malloc: %s(%d)\n", myname, strerror(errno), errno);
	exit(1);
      };
      strcpy((*pd)->name, buffer);
      pd = &((*pd)->next);
    };
  };

  if (closedir(dir) < 0) {
    fprintf(stderr, "%s: closedir: %s(%d)\n", myname, strerror(errno), errno);
    exit(1);
  };
};

int main(int argc, char **argv)
{
  struct stat stat;
  int i, j, maxfd;
  int quick = 0;

  INIT(argc, argv);

  while ((i = getopt(argc, argv, STDOPTS_FLAGS "q")) != EOF) {
    switch(i) {
      case 'q':
        quick = 1;
	break;
      STDOPTS_CASES
    };
  };

  if (!quick) {
    struct inotoname **pi;

    for (i = 0, j = 0, maxfd = 0; i < sysconf(_SC_OPEN_MAX); i++) {
      if (!fstat(i, &stat)) {
	maxfd = i;
	for (pi = &inotonames; *pi && ((*pi)->ino != stat.st_ino); pi = &((*pi)->next));
	if (!*pi) {
	  if (!(*pi = malloc(sizeof(struct inotoname)))) {
	    fprintf(stderr, "%s: malloc: %s(%d)\n", myname, strerror(errno), errno);
	    exit(1);
	  };
	  memset(*pi, 0, sizeof(struct inotoname));
	  (*pi)->ino = stat.st_ino;
	  j++;
	};
      };
    };

    if (j) {
      printf("%s: searching for %d inode%s... ", myname, j, (j > 1) ? "s" : "");
      fflush(stdout);
      
      inodesearch("/");
      
      {
	struct dirname *dirname;
	while(dirnames) {
	  dirname = dirnames;
	  if (!(dirnames = dirnames->next))
	    pd = &dirnames;
	  
	  inodesearch(dirname->name);
	  free(dirname->name);
	  free(dirname);
	};
      };
      printf("\n");
    };
  };

  {
    struct inotoname *inotoname;
    char hbuf[64], sbuf[32];
    su laddr, faddr;

    for (i = 0; i <= maxfd; i++) {
      if (!fstat(i, &stat)) {
	printf("fd %d is a ", i);
	if (S_ISLNK(stat.st_mode))
	  printf("symlink");
	if (S_ISREG(stat.st_mode))
	  printf("file ");
	if (S_ISDIR(stat.st_mode))
	  printf("directory ");
	if (S_ISCHR(stat.st_mode))
	  printf("character device ");
	if (S_ISBLK(stat.st_mode))
	  printf("block device ");
	if (S_ISFIFO(stat.st_mode))
	  printf("FIFO/pipe ");
	if (S_ISSOCK(stat.st_mode)) {
	  printf("socket ");
	  j = sizeof(su);
	  if (getsockname(i, (struct sockaddr *)&laddr, &j) < 0) {
	    fprintf(stderr, "%s: getsockname: %s(%d)\n", myname, strerror(errno), errno);
	    exit(1);
	  };
	  j = sizeof(su);
	  if (getpeername(i, (struct sockaddr *)&faddr, &j) < 0) {
	    fprintf(stderr, "%s: getpeername: %s(%d)\n", myname, strerror(errno), errno);
	    exit(1);
	  };
	  if (getnameinfo((struct sockaddr *)&laddr, NRL_SA_LEN((struct sockaddr *)&laddr), hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), 0)) {
	    fprintf(stderr, "%s: getnameinfo failed\n", myname);
	    exit(1);
	  };
	  printf("(local: %s.%s", hbuf, sbuf);
	  if (getnameinfo((struct sockaddr *)&laddr, NRL_SA_LEN((struct sockaddr *)&laddr), hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), NI_NUMERICHOST | NI_NUMERICSERV)) {
	    fprintf(stderr, "%s: getnameinfo failed\n", myname);
	    exit(1);
	  };
	  printf("(%s.%s) ", hbuf, sbuf);
	  if (getnameinfo((struct sockaddr *)&faddr, NRL_SA_LEN((struct sockaddr *)&faddr), hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), 0)) {
	    fprintf(stderr, "%s: getnameinfo failed\n", myname);
	    exit(1);
	  };
	  printf("foreign: %s.%s", hbuf, sbuf);
	  if (getnameinfo((struct sockaddr *)&faddr, NRL_SA_LEN((struct sockaddr *)&faddr), hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), NI_NUMERICHOST | NI_NUMERICSERV)) {
	    fprintf(stderr, "%s: getnameinfo failed\n", myname);
	    exit(1);
	  };
	  printf("(%s.%s)) ", hbuf, sbuf);
	};
	if (stat.st_ino) {
	  for (inotoname = inotonames; inotoname && (inotoname->ino != stat.st_ino); inotoname = inotoname->next);
	  if (inotoname && inotoname->name)
	    printf("(%s) ", inotoname->name);
	};
	printf("\n\tdev=%d ino=%d mode=%o nlink=%d uid=%d gid=%d rdev=%d size=%d blksize=%d blocks=%d atime=%d mtime=%d ctime=%d\n", stat.st_dev, (int)stat.st_ino, stat.st_mode, stat.st_nlink, stat.st_uid, stat.st_gid, stat.st_rdev, (int)stat.st_size, (int)stat.st_blksize, (int)stat.st_blocks, (int)stat.st_atime, (int)stat.st_mtime, (int)stat.st_ctime);
      };
    };
  };
  return 0;
};
