/*
%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

v0.03 - NOT FOR REDISTRIBUTION.
*/
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet6/in6.h>
#include <syslog.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>

#include "support.h"
#include "inner-apps.h"

static char hextab[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

void dump_sockaddr(struct sockaddr *sa, int len)
{
  char hbuf[HNAME_MAX], sbuf[SNAME_MAX];

  if (!len)
    len = NRL_SA_LEN(sa);

  syslog(LOG_DEBUG, "len = %d, sa_len = %d, sa_family = %d", len, NRL_SA_LEN(sa), sa->sa_family);
  {
    int i = len;
    char *c = hbuf;
    u_int8_t *p = (u_int8_t *)sa->sa_data;

    i -= ((unsigned)sa->sa_data - (unsigned)sa);

    while(i--) {
      *(c++) = hextab[(*p & 0xf0) >> 4];
      *(c++) = hextab[(*(p++) & 0x0f)];
    }
    *c = 0;
  }
  syslog(LOG_DEBUG, "sa_data = %s", hbuf);

  if ((sa->sa_family < AF_MAX) && NRL_SA_LEN(sa) && getnameinfo(sa, len, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), NI_NUMERICHOST | NI_NUMERICSERV)) {
    syslog(LOG_DEBUG, "getnameinfo failed");
    return;
  };
  syslog(LOG_DEBUG, "addr = %s, port = %s", hbuf, sbuf);
};
