/* netdb.h */

/*
%%% portions-copyright-cmetz
Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net License Version 2 applies to these portions of
the software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/

#ifndef __netdb6_h
#define __netdb6_h

#include_next <netdb.h>

#define AI_PASSIVE      1 /* socket address is intended for bind() */
#define AI_CANONNAME    2 /* request for canonical name */

#define EAI_BADFLAGS     -1 /* invalid value for ai_flags */
#define EAI_NONAME       -2 /* name or service is not known */
#define EAI_AGAIN        -3 /* temporary failure in name resolution */
#define EAI_FAIL         -4 /* non-recoverable failure in name resolution */
#define EAI_NODATA       -5 /* no address associated with name */
#define EAI_FAMILY       -6 /* ai_family not supported */
#define EAI_SOCKTYPE     -7 /* ai_socktype not supported */
#define EAI_SERVICE      -8 /* service not supported for ai_socktype */
#define EAI_ADDRFAMILY   -9 /* address family for name not supported */
#define EAI_MEMORY      -10 /* memory allocation failure */
#define EAI_SYSTEM      -11 /* system error (code indicated in errno) */

struct addrinfo {
  int ai_flags;             /* input flags */
  int ai_family;            /* protocol family for socket */
  int ai_socktype;          /* socket type */
  int ai_protocol;          /* protocol for socket */
  int ai_addrlen;           /* length of socket-address */
  struct sockaddr *ai_addr; /* socket-address for socket */
  char *ai_canonname;       /* canonical name for service location (iff req) */
  struct addrinfo *ai_next; /* pointer to next in list */
};

int getaddrinfo(const char *name, const char *service,
		const struct addrinfo *req, struct addrinfo **pai);

void freeaddrinfo(struct addrinfo *ai);
char *gai_strerror(int ecode);

#define NI_MAXHOST 1025
#define NI_MAXSERV 32

#define NI_NUMERICHOST 1
#define NI_NUMERICSERV 2
#define NI_NOFQDN 4
#define NI_NAMEREQD 8
#define NI_DGRAM 16
int getnameinfo __P((const struct sockaddr *sa, size_t addrlen, char *host, size_t hostlen, char *serv, size_t servlen, int flags));

int inet_pton __P((int af, const char *cp, void *ap));
const char *inet_ntop __P((int af, const void *ap, char *cp, size_t len));

#endif
