#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet6/in6.h>
#include <net/if.h>

#define SERV_PORT	2000
#define NPACKS		5

static void serv(void)
{
	char buf1[4096];
	int sk, sk2;
	int err, i;
	struct sockaddr_in6 usin;
	int addr_len = sizeof(struct sockaddr_in6);
		
	fprintf(stderr, "serv: starting\n");

	sk = socket(AF_INET6, SOCK_STREAM, 0);
	
	if (sk < 0)
	{
		perror("serv: sys_socket");
		return;
	}

	memset(&usin, 0, sizeof(struct sockaddr_in6));

	usin.sin6_family = AF_INET6;
	usin.sin6_port = htons(SERV_PORT);

	err = bind(sk, (struct sockaddr*) &usin, sizeof(usin));
	if (err)
	{
		perror("serv: bind");
		return;
	}

	err = listen(sk, 1);
	if (err)
	{
		perror("serv: listen");
		return;
	}

	fprintf(stderr, "listen ok\n");

	sk2 = accept(sk, (struct sockaddr *) &usin, &addr_len);
	if (sk2 < 0)
	{
		perror("serv: accept");
		return;
	}


	for (i = 0; i < NPACKS; i++)
	{
		err = recv(sk2, buf1, 4096, 0);
		if (err < 0)
		{
			perror("serv: recv");
			return;
		}
		fprintf(stderr, "serv: recv len=%d\n", err);

		err = send(sk2, buf1, err, 0);

		if (err < 0)
		{
			perror("serv: send");
			return;
		}

	}
	close(sk2);
	close(sk);
}

#define PAT_MOD 17

static void fillpattern(char *buf, int len)
{
	int i;

	for (i=0; i<len; i++)
		buf[i] = i % PAT_MOD;
}

static int testpattern(char *buf, int len)
{
	int i;

	for (i=0; i<len; i++)
		if (buf[i] != i % PAT_MOD)
			return -1;

	return 0;
}

static void cli(void)
{
	char buf1[4096];
	char buf2[4096];
	int sk;
	int err, i;
	struct sockaddr_in6 usin;

	fprintf(stderr, "cli: starting\n");

	sk = socket(AF_INET6, SOCK_STREAM, 0);
	
	if (sk < 0)
	{
		perror("cli: sys_socket");
		return;
	}

	memset(&usin, 0, sizeof(struct sockaddr_in6));

	usin.sin6_family = AF_INET6;
	usin.sin6_port = htons(SERV_PORT);

	/* ::127.0.0.1 */
	usin.sin6_addr.s6_addr32[3] = inet_addr("127.0.0.1");

	err = connect(sk, (struct sockaddr *)&usin, 
		      sizeof(struct sockaddr_in6));

	if (err < 0)
	{
		perror("cli: connect");
		return;
	}


	for (i = 0; i < NPACKS; i++)
	{
		fillpattern(buf1, 256);
		
		err = send(sk, buf1, 256, 0);
		if (err < 0)
		{
			perror("cli: send");
			return;
		}


		fprintf(stderr, "cli: snd ok\n");

		err = recv(sk, buf2, 256, 0);
		if (err < 0)
		{
			perror("cli: recvfrom");
			return;
		}

		fprintf(stderr, "cli: rcv ok len=%d\n", err);
		
		if (testpattern(buf2, 256))
			fprintf(stderr, "error in pattern\n");
	}
	
}

int main(int argc, char *argv[])
{
	if (fork())
	{
		serv();
		wait(NULL);
	}
	else
	{
		cli();
		exit(0);
	}
	return 0;
}
