#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/unistd.h>
#include <sys/sysctl.h>

_syscall1(int, _sysctl, struct __sysctl_args *, args);

int main(int argc, char *argv[])
{
	struct __sysctl_args args;
	int ctl_forward[] = {CTL_NET, NET_IPV6, NET_IPV6_FORWARDING};
	int val = 0;
	int set = 0;
	int len;
	int err;

	if (argc > 1)
	{
		if (argc != 3 || strcmp(argv[1], "-s"))
		{
			fprintf(stderr, "%s: [-s val]\n", argv[0]);
			exit(1);
		}
		val = atoi(argv[2]);
		set = 1;
		
	}

	memset(&args, 0, sizeof(args));
	args.name = ctl_forward;
	args.nlen = 3;
	
	if (set)
	{
		args.newval = &val;
		args.newlen = sizeof(val);
	}
	else
	{
		args.oldval = &val;
		len = sizeof(val);
		args.oldlenp = &len;
	}

	err = _sysctl(&args);
	if (err)
	{
		perror("sysctl");
	}

	if (!set)
	{
		fprintf(stdout, "value: %d\n", val);
	}

	return err;
}


