#include "timer.h"
#include "debug.h"
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <sys/time.h>


static struct timer_lst timers_head = {
	~0,
	NULL, NULL,
	&timers_head, &timers_head
};

static unsigned long sched_timer = 0;

void alarm_handler(int sig);


void set_timer(struct timer_lst *tm, int secs)
{
	struct timeval tv;
	struct timer_lst *lst;
	sigset_t bmask, oldmask;

	dprintf(3, "seting timer: %d secs\n", secs);

	sigemptyset(&bmask);
	sigaddset(&bmask, SIGALRM);

	sigprocmask(SIG_BLOCK, &bmask, &oldmask);

	gettimeofday(&tv, NULL);
	tm->expires = tv.tv_sec + secs;
	
	lst = &timers_head;

	do {
		lst = lst->next;
	} while (tm->expires > lst->expires);

	tm->next = lst;
	tm->prev = lst->prev;
	lst->prev = tm;
	tm->prev->next = tm;

	if (sched_timer == 0 || sched_timer > tm->expires)
	{		
		signal(SIGALRM, alarm_handler);
		sched_timer = tm->expires;		
		dprintf(4, "calling alarm: %d secs\n", secs);
		alarm(secs);
	}

	sigprocmask(SIG_SETMASK, &oldmask, NULL);
}

void clear_timer(struct timer_lst *tm)
{
	sigset_t bmask, oldmask;

	sigemptyset(&bmask);
	sigaddset(&bmask, SIGALRM);

	sigprocmask(SIG_BLOCK, &bmask, &oldmask);
		
	tm->prev->next = tm->next;
	tm->next->prev = tm->prev;
	
	tm->prev = tm->next = NULL;
	
	tm = timers_head.next;

	if (tm != &timers_head)
	{
		struct timeval tv;
		long secs;
	
		gettimeofday(&tv, NULL);
		secs = tv.tv_sec - tm->expires;
		sched_timer = tm->expires;

		if (secs < 0)
			secs = 0;

		dprintf(4, "calling alarm: %d secs\n", secs);
		alarm(secs);
	}
	else
		sched_timer = 0;

	sigprocmask(SIG_SETMASK, &oldmask, NULL);
}

void alarm_handler(int sig)
{
	struct timer_lst *tm, *back;
	struct timeval tv;

	tm = timers_head.next;

	gettimeofday(&tv, NULL);

	while (tm->expires <= tv.tv_sec)
	{		
		tm->prev->next = tm->next;
		tm->next->prev = tm->prev;

		back = tm;
		tm = tm->next;
		back->prev = back->next = NULL;

		(*back->handler)(back->data);
	}

	tm = timers_head.next;

	if (tm != &timers_head)
	{
		long secs;
	       
		secs = tm->expires - tv.tv_sec;
		sched_timer = tm->expires;

		if (secs <= 0)
		{
			secs = 1;
		}

		signal(SIGALRM, alarm_handler);
		dprintf(4, "calling alarm: %d secs\n", secs);
		alarm(secs);
	}
	else
		sched_timer = 0;
}

/*
 * Local variables:
 * c-file-style: "Linux"
 * End:
 */
