/*
%%% portions-copyright-cmetz-96
Portions of this software are Copyright 1996-1997 by Craig Metz, All Rights
Reserved. The Inner Net License Version 2 applies to these portions of
the software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
/*
 * inet_ntop.c  --  Implements translation of addresses to human-readable
 *                   form.
 *
 * Copyright 1995 by Randall Atkinson, Bao Phan, and Dan McDonald
 *	All Rights Reserved.  
 *      All Rights under this copyright have been assigned to NRL.
 */

/*----------------------------------------------------------------------
#	@(#)COPYRIGHT	1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

	This product includes software developed at the Information
	Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/

#include <sys/types.h>

#include <netinet/in.h>
#if INET6
#include <netinet6/in6.h>
#endif /* INET6 */
#ifndef linux
#include <netns/ns.h>

struct iso_addr;
char *iso_ntoa __P((struct iso_addr *));
struct sockaddr_dl;
char *link_ntoa __P((struct sockaddr_dl *));
#endif /* linux */

#include <arpa/inet.h>
#include <sys/socket.h>
#include <stdio.h>
#include <string.h>

#include "support.h"

static char inet_ntop_buffer[INET6_ADDRSTRLEN];

#ifndef min
#define min(x,y) ( ((x) < (y)) ? (x) : (y) )
#endif /* min */

#if INET6
static char hextab[] = { '0', '1', '2', '3', '4', '5', '6', '7',
                         '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

extern const struct in6_addr nrl_in6addr_mapped;

static char *_inet6_ntoa(ap)
     void *ap;
{
  static char buffer[INET6_ADDRSTRLEN];
  char *op = buffer;

  /*
   * Treat v4-mapped and v4-compatible differently.
   * (In fact v4-mapped, may want to just return the v4 address.)
   */
  if (IN6_IS_ADDR_V4MAPPED(ap)) {
    strcpy(op,"::ffff:");
    op += 7;
    inet_ntop(AF_INET, (ap + 12), op, 38);
    return buffer;
  }
  if (IN6_IS_ADDR_V4COMPAT(ap)) {
    strcpy(op,"::");
    op += 2;
    inet_ntop(AF_INET, (ap + 12), op, 43);
    return buffer;
  }

  *op = '\0';

  {
    char unpack[4];
    int i, j, k;
    int start = 0, len = 0;
    unsigned short *sp;

    for (i = j = k = 0, sp = (unsigned short *)ap; i < 8; i++) {
      if (*(sp++)) {
	if (j >= len) {
	  start = k;
	  len = j;
	  j = 0;
	}
      } else {
	if (!(j++))
	  k = i;
      }
    }
    if (j >= len) {
      start = k;
      len = j;
    }

#ifdef DEBUG
    fprintf(stderr, "start = %d, len = %d\n", start, len);
#endif /* DEBUG */

    if (len < 2)
      start = 9;

    if (!start)
      *(op++) = ':';

    i = 0;
    while(i < 8) {
      if (i == start) {
	*(op++) = ':';
	ap += len * 2;
	i += len;
	continue;
      }

      unpack[0] = ((*(char *)ap) & 0xf0) >> 4;
      unpack[1] =  (*(char *)ap) & 0x0f; ap++;
      unpack[2] = ((*(char *)ap) & 0xf0) >> 4;
      unpack[3] =  (*(char *)ap) & 0x0f; ap++;

      for (j = 0; (j < 3) && !unpack[j]; j++);
      while(j < 4)
	*(op++) = hextab[unpack[j++]];
      
      *(op++) = ':';
      i++;
    }
    if ((start + len) == 8) 
      *(op++) = '0';
    else
      --op;
    *op = 0;
  }

  return buffer;
}
#endif /* INET6 */

const char *inet_ntop(af, ap, cp, len)
int af;
const void *ap;
char *cp;
size_t len;
{
  char *ptr;
  int maxlen;

  ptr = NULL;
  if (!cp) {
    cp = inet_ntop_buffer;
    if (len)
      len = min(len, sizeof(inet_ntop_buffer));
    else
      len = sizeof(inet_ntop_buffer);
  }

  switch(af) {
  case AF_INET:
    ptr = inet_ntoa(*((struct in_addr *)ap));
    len = min(len, INET_ADDRSTRLEN);
    break;

#if INET6
  case AF_INET6:
    ptr = _inet6_ntoa(ap);
    len = min(len, INET6_ADDRSTRLEN);
    break;
#endif /* INET6 */

#ifndef linux
#ifdef AF_ISO
  case AF_ISO:
    ptr = iso_ntoa((struct iso_addr *)ap);
    /* len? */
    break;
#endif /* AF_ISO */

#ifdef AF_NS
  case AF_NS:
    ptr = ns_ntoa(*((struct ns_addr *)ap));
    /* len? */
    break;
#endif /* AF_NS */

#ifdef AF_LINK
  case AF_LINK:
    ptr = link_ntoa((struct sockaddr_dl *)ap);
    /* len? */
    break;
#endif /* AF_LINK */
#endif /* linux */
  }

  if (ptr) {
    strncpy(cp, ptr, len);
    cp[len-1] = 0;
    return cp;
  }

  return NULL;
}

#if 0
const char *addr2ascii(af, ap, len, cp)
int af;
/* const */ void *ap;
int len;
char *cp;
{
  return inet_ntop(af, ap, cp, INET6_ADDRSTRLEN);
}
#endif /* 0 */
